/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.crate;

import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.embedded.chicory.runtime.Memory;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;

public class CrateStorage {
    public static final int STORAGE_SIZE = 524288;
    private final byte[] data = new byte[524288];
    private final Path filePath;
    private boolean dirty = false;
    private static final byte[] FF_MAGIC = new byte[]{103, 115, 98, 99, 114, 97, 116, 101};
    private static final int FF_VERSION = 1;

    public CrateStorage(String name) {
        this.filePath = CrateStorage.resolveFilePath(name);
        this.load();
    }

    public static Path resolveFilePath(String name) {
        return Gooseboy.getGooseboyDirectory().resolve("storage").resolve(name + ".bin");
    }

    public static long getSizeOf(String name) {
        Path filePath = CrateStorage.resolveFilePath(name);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return 0L;
        }
        try {
            return Files.size(filePath);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public int read(Memory mem, int offset, int wasmPtr, int len) {
        if (offset < 0 || offset >= 524288) {
            return 0;
        }
        int toRead = Math.min(len, 524288 - offset);
        byte[] chunk = new byte[toRead];
        System.arraycopy(this.data, offset, chunk, 0, toRead);
        mem.write(wasmPtr, chunk);
        return toRead;
    }

    public int write(Memory mem, int offset, int wasmPtr, int len) {
        if (offset < 0 || offset >= 524288) {
            return 0;
        }
        int toWrite = Math.min(len, 524288 - offset);
        byte[] chunk = mem.readBytes(wasmPtr, toWrite);
        System.arraycopy(chunk, 0, this.data, offset, toWrite);
        this.dirty = true;
        return toWrite;
    }

    public void clear() {
        Arrays.fill(this.data, (byte)0);
        this.dirty = true;
    }

    public int size() {
        return 524288;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] gzipCompressData() {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(output);){
                gzip.write(this.data);
                gzip.finish();
                byArray = output.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            Gooseboy.LOGGER.error("Failed to compress storage crate:", (Throwable)e);
            return new byte[0];
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] decompressGZIPData(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void load() {
        try {
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.filePath, new LinkOption[0])) {
                return;
            }
            try (DataInputStream in = new DataInputStream(Files.newInputStream(this.filePath, new OpenOption[0]));){
                CompressionType compressionType;
                byte[] magic = in.readNBytes(FF_MAGIC.length);
                if (!Arrays.equals(magic, FF_MAGIC)) {
                    Gooseboy.LOGGER.error("Invalid storage crate file, magic identifier is wrong!");
                    return;
                }
                int readVersion = in.readInt();
                if (readVersion != 1) {
                    Gooseboy.LOGGER.error("Incompatible storage crate version: {}", (Object)readVersion);
                    return;
                }
                byte compressionCode = in.readByte();
                try {
                    compressionType = CompressionType.fromCode(compressionCode);
                }
                catch (IllegalArgumentException ex) {
                    Gooseboy.LOGGER.error("Unknown compression code in storage crate: {}", (Object)compressionCode);
                    in.close();
                    return;
                }
                int compressedLength = in.readInt();
                int uncompressedLength = in.readInt();
                byte[] compressed = in.readNBytes(compressedLength);
                if (compressed.length != compressedLength) {
                    Gooseboy.LOGGER.error("Storage crate expected {} compressed bytes but read {}", (Object)compressedLength, (Object)compressed.length);
                    return;
                }
                byte[] decompressed = compressed;
                if (compressionType == CompressionType.GZIP) {
                    decompressed = this.decompressGZIPData(compressed);
                }
                if (decompressed.length != uncompressedLength) {
                    Gooseboy.LOGGER.error("Storage crate uncompressed size {} != expected {}", (Object)decompressed.length, (Object)uncompressedLength);
                    return;
                }
                System.arraycopy(decompressed, 0, this.data, 0, Math.min(decompressed.length, 524288));
            }
        }
        catch (IOException e) {
            Gooseboy.LOGGER.error("Failed to load WASM storage crate:", (Throwable)e);
        }
    }

    public void save() {
        if (!this.dirty) {
            return;
        }
        try {
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            byte[] compressedData = this.gzipCompressData();
            CompressionType compression = CompressionType.GZIP;
            Path temp = this.filePath.resolveSibling(this.filePath.getFileName().toString() + ".tmp");
            try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(temp, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
                out.write(FF_MAGIC);
                out.writeInt(1);
                out.writeByte(compression.code);
                out.writeInt(compressedData.length);
                out.writeInt(this.data.length);
                out.write(compressedData);
            }
            try {
                Files.move(temp, this.filePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ex) {
                Files.move(temp, this.filePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            Gooseboy.LOGGER.error("Failed to save WASM storage crate:", (Throwable)e);
        }
    }

    static enum CompressionType {
        NONE(0),
        GZIP(1);

        private final byte code;

        private CompressionType(byte code) {
            this.code = code;
        }

        public static CompressionType fromCode(byte code) {
            for (CompressionType e : CompressionType.values()) {
                if (e.code != code) continue;
                return e;
            }
            throw new IllegalArgumentException("Unknown code: " + code);
        }
    }
}

