/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.crate;

import awildgoose.gooseboy.ConfigManager;
import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.crate.CrateStorage;
import awildgoose.gooseboy.crate.CrateUtils;
import awildgoose.gooseboy.embedded.chicory.runtime.ExportFunction;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.embedded.chicory.runtime.Memory;
import awildgoose.gooseboy.embedded.chicory.runtime.TrapException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10209;
import net.minecraft.class_3695;

public class GooseboyCrate {
    public final Instance instance;
    private int fbPtr;
    public int fbSize;
    private ExportFunction updateFunction;
    public CrateStorage storage;
    public final String name;
    public final List<Permission> permissions;
    public boolean isOk = true;

    public GooseboyCrate(Instance instance, String name) {
        this.instance = instance;
        this.name = name;
        this.permissions = this.loadPermissions();
        this.init();
    }

    private void init() {
        this.fbSize = 256000;
        this.storage = new CrateStorage(this.name);
        Gooseboy.addCrate(this);
        try {
            this.instance.export("main").apply(new long[0]);
            this.fbPtr = (int)this.instance.export("get_framebuffer_ptr").apply(new long[0])[0];
            this.updateFunction = this.instance.export("update");
        }
        catch (Throwable ie) {
            this.close();
            if (ie instanceof TrapException) {
                this.isOk = false;
                ie.printStackTrace();
            }
            throw ie;
        }
    }

    public void clearSurface(int ptr, int size, int color) {
        Memory mem = this.instance.memory();
        for (int i = 0; i < size; i += 4) {
            mem.writeI32(ptr + i, color);
        }
    }

    public byte[] getFramebufferBytes() {
        return this.instance.memory().readBytes(this.fbPtr, this.fbSize);
    }

    public void update() {
        if (this.updateFunction != null) {
            class_3695 profilerFiller = class_10209.method_64146();
            long now = System.nanoTime();
            profilerFiller.method_15396("gooseboy");
            try {
                this.updateFunction.apply(now);
            }
            catch (TrapException e) {
                this.isOk = false;
                e.printStackTrace();
            }
            profilerFiller.method_15407();
        }
    }

    public void close() {
        this.savePermissions();
        this.storage.save();
        CrateUtils.clearWarns();
        Gooseboy.ccb.closeCrate(this);
        Gooseboy.removeCrate(this);
    }

    private List<Permission> loadPermissions() {
        return ConfigManager.getEffectivePermissions(this.name);
    }

    private void savePermissions() {
        ConfigManager.setCratePermissions(this.name, this.permissions);
    }

    public static enum Permission {
        CONSOLE(0),
        AUDIO(1),
        INPUT_KEYBOARD(2),
        INPUT_MOUSE(3),
        INPUT_MOUSE_POS(4),
        INPUT_GRAB_MOUSE(5),
        STORAGE_READ(6),
        STORAGE_WRITE(7),
        EXTENDED_MEMORY(8),
        EXTENDED_EXTENDED_MEMORY(9);

        private final int id;

        private Permission(int id) {
            this.id = id;
        }

        public static Optional<Permission> intToEnum(int i) {
            return Arrays.stream(Permission.values()).filter(f -> f.id == i).findFirst();
        }
    }
}

