/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.embedded.chicory.compiler;

import awildgoose.gooseboy.embedded.chicory.compiler.InterpreterFallback;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.ClassLoadingCollector;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.Compiler;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.CompilerResult;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.MachineFactory;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.embedded.chicory.runtime.Machine;
import awildgoose.gooseboy.embedded.chicory.wasm.WasmModule;
import java.util.Set;
import java.util.function.Function;

public final class MachineFactoryCompiler {
    private MachineFactoryCompiler() {
    }

    public static Machine compile(Instance instance) {
        return MachineFactoryCompiler.compile(instance.module()).apply(instance);
    }

    public static Function<Instance, Machine> compile(WasmModule module) {
        return new MachineFactory(module);
    }

    public static Builder builder(WasmModule module) {
        return new Builder(module);
    }

    public static final class Builder {
        private final WasmModule module;
        private final Compiler.Builder compilerBuilder;

        private Builder(WasmModule module) {
            this.module = module;
            this.compilerBuilder = Compiler.builder(module);
        }

        public Builder withClassName(String className) {
            this.compilerBuilder.withClassName(className);
            return this;
        }

        public Builder withMaxFunctionsPerClass(int maxFunctionsPerClass) {
            this.compilerBuilder.withMaxFunctionsPerClass(maxFunctionsPerClass);
            return this;
        }

        public Builder withInterpreterFallback(InterpreterFallback interpreterFallback) {
            this.compilerBuilder.withInterpreterFallback(interpreterFallback);
            return this;
        }

        public Builder withInterpretedFunctions(Set<Integer> interpretedFunctions) {
            this.compilerBuilder.withInterpretedFunctions(interpretedFunctions);
            return this;
        }

        public Function<Instance, Machine> compile() {
            CompilerResult result = this.compilerBuilder.withClassCollectorFactory(ClassLoadingCollector::new).build().compile();
            ClassLoadingCollector collector = (ClassLoadingCollector)result.collector();
            return new MachineFactory(this.module, collector.machineFactory());
        }
    }
}

