/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.embedded.chicory.compiler.internal;

import awildgoose.gooseboy.embedded.chicory.compiler.internal.ClassCollector;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.Shader;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.WasmClassLoader;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.embedded.chicory.runtime.Machine;
import awildgoose.gooseboy.embedded.chicory.wasm.ChicoryException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.util.CheckClassAdapter;

public class ClassLoadingCollector
implements ClassCollector {
    private final WasmClassLoader classLoader;
    private LinkedHashMap<String, byte[]> classBytes = new LinkedHashMap();
    private String mainClass;
    private Function<Instance, Machine> machineFactory;

    public ClassLoadingCollector() {
        this.classLoader = new WasmClassLoader();
    }

    @Override
    public String mainClassName() {
        return this.mainClass;
    }

    @Override
    public void putMainClass(String className, byte[] bytes) {
        this.mainClass = className;
        this.loadClass(bytes);
        LinkedHashMap<String, byte[]> classBytes = new LinkedHashMap<String, byte[]>();
        classBytes.put(className, bytes);
        classBytes.putAll(this.classBytes);
        this.classBytes = classBytes;
    }

    @Override
    public void put(String className, byte[] bytes) {
        this.loadClass(bytes);
        this.classBytes.put(className, bytes);
    }

    @Override
    public void putAll(ClassCollector collector) {
        Map<String, byte[]> classBytes = collector.classBytes();
        this.classBytes.putAll(classBytes);
        for (byte[] bytes : classBytes.values()) {
            this.loadClass(bytes);
        }
    }

    @Override
    public Map<String, byte[]> classBytes() {
        return Collections.unmodifiableMap(this.classBytes);
    }

    @Override
    public byte[] resolve(Class<?> clazz) {
        return Shader.getBytecode(clazz);
    }

    public Function<Instance, Machine> machineFactory() {
        if (this.machineFactory == null) {
            Objects.requireNonNull(this.mainClass);
            this.machineFactory = this.createMachineFactory(this.mainClass);
        }
        return this.machineFactory;
    }

    private Function<Instance, Machine> createMachineFactory(String name) {
        try {
            Class<Machine> clazz = this.classLoader.loadClass(name).asSubclass(Machine.class);
            Constructor<Machine> constructor = clazz.getConstructor(Instance.class);
            MethodHandle handle = MethodHandles.publicLookup().unreflectConstructor(constructor);
            Function function = MethodHandleProxies.asInterfaceInstance(Function.class, handle);
            return function;
        }
        catch (ReflectiveOperationException e) {
            throw new ChicoryException(e);
        }
    }

    private Class<?> loadClass(byte[] classBytes) {
        try {
            Class<?> clazz = this.classLoader.loadFromBytes(classBytes);
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (VerifyError e) {
            try {
                StringWriter out = new StringWriter().append("ASM verifier:\n\n");
                CheckClassAdapter.verify((ClassReader)new ClassReader(classBytes), (boolean)true, (PrintWriter)new PrintWriter(out));
                e.addSuppressed(new RuntimeException(out.toString()));
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
            throw e;
        }
    }
}

