/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.embedded.chicory.compiler.internal;

import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.embedded.chicory.runtime.Memory;
import awildgoose.gooseboy.embedded.chicory.wasm.types.FunctionBody;
import awildgoose.gooseboy.embedded.chicory.wasm.types.FunctionType;
import awildgoose.gooseboy.embedded.chicory.wasm.types.ValType;
import awildgoose.gooseboy.embedded.chicory.wasm.types.Value;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class CompilerUtil {
    private static final int MAX_PARAMETER_COUNT = 253;
    private static final Method LONG_TO_F32;
    private static final Method LONG_TO_F64;
    private static final Method F32_TO_LONG;
    private static final Method F64_TO_LONG;

    private CompilerUtil() {
    }

    public static Class<?> jvmType(ValType type) {
        switch (type.opcode()) {
            case 99: 
            case 100: 
            case 105: 
            case 127: {
                return Integer.TYPE;
            }
            case 126: {
                return Long.TYPE;
            }
            case 125: {
                return Float.TYPE;
            }
            case 124: {
                return Double.TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported ValType: " + String.valueOf(type));
    }

    public static Type asmType(ValType type) {
        switch (type.opcode()) {
            case 99: 
            case 100: 
            case 105: 
            case 127: {
                return Type.INT_TYPE;
            }
            case 126: {
                return Type.LONG_TYPE;
            }
            case 125: {
                return Type.FLOAT_TYPE;
            }
            case 124: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static ValType localType(FunctionType type, FunctionBody body, int localIndex) {
        if (localIndex < type.params().size()) {
            return type.params().get(localIndex);
        }
        return body.localTypes().get(localIndex - type.params().size());
    }

    public static void emitLongToJvm(MethodVisitor asm, ValType type) {
        switch (type.opcode()) {
            case 99: 
            case 100: 
            case 105: 
            case 127: {
                asm.visitInsn(136);
                return;
            }
            case 126: {
                return;
            }
            case 125: {
                CompilerUtil.emitInvokeStatic(asm, LONG_TO_F32);
                return;
            }
            case 124: {
                CompilerUtil.emitInvokeStatic(asm, LONG_TO_F64);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported ValType: " + String.valueOf(type));
    }

    public static void emitJvmToLong(MethodVisitor asm, ValType type) {
        switch (type.opcode()) {
            case 99: 
            case 100: 
            case 105: 
            case 127: {
                asm.visitInsn(133);
                return;
            }
            case 126: {
                return;
            }
            case 125: {
                CompilerUtil.emitInvokeStatic(asm, F32_TO_LONG);
                return;
            }
            case 124: {
                CompilerUtil.emitInvokeStatic(asm, F64_TO_LONG);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported ValType: " + String.valueOf(type));
    }

    public static MethodType valueMethodType(List<ValType> types) {
        return MethodType.methodType(long[].class, CompilerUtil.jvmTypes(types));
    }

    public static MethodType callIndirectMethodType(FunctionType functionType) {
        return CompilerUtil.rawMethodTypeFor(functionType).appendParameterTypes(Integer.TYPE, Integer.TYPE, Memory.class, Instance.class);
    }

    public static MethodType methodTypeFor(FunctionType type) {
        return CompilerUtil.rawMethodTypeFor(type).appendParameterTypes(Memory.class, Instance.class);
    }

    public static boolean hasTooManyParameters(FunctionType type) {
        return type.params().stream().mapToInt(CompilerUtil::slotCount).sum() > 253;
    }

    public static MethodType rawMethodTypeFor(FunctionType type) {
        Class<?>[] classArray;
        if (CompilerUtil.hasTooManyParameters(type)) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = long[].class;
        } else {
            classArray = CompilerUtil.jvmParameterTypes(type);
        }
        Class<?>[] paramsTypes = classArray;
        return MethodType.methodType(CompilerUtil.jvmReturnType(type), paramsTypes);
    }

    public static Class<?>[] jvmTypes(List<ValType> types) {
        return (Class[])types.stream().map(CompilerUtil::jvmType).toArray(Class[]::new);
    }

    public static Class<?>[] jvmParameterTypes(FunctionType type) {
        return CompilerUtil.jvmTypes(type.params());
    }

    public static Class<?> jvmReturnType(FunctionType type) {
        switch (type.returns().size()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return CompilerUtil.jvmType(type.returns().get(0));
            }
        }
        return long[].class;
    }

    public static Object defaultValue(ValType type) {
        switch (type.opcode()) {
            case 127: {
                return 0;
            }
            case 126: {
                return 0L;
            }
            case 125: {
                return Float.valueOf(0.0f);
            }
            case 124: {
                return 0.0;
            }
            case 99: 
            case 100: 
            case 105: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Unsupported ValType: " + String.valueOf(type));
    }

    public static int slotCount(ValType type) {
        switch (type.opcode()) {
            case 99: 
            case 100: 
            case 105: 
            case 125: 
            case 127: {
                return 1;
            }
            case 124: 
            case 126: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static void emitPop(MethodVisitor asm, ValType type) {
        asm.visitInsn(CompilerUtil.slotCount(type) == 1 ? 87 : 88);
    }

    public static void emitInvokeStatic(MethodVisitor asm, Method method) {
        assert (Modifier.isStatic(method.getModifiers()));
        asm.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    public static void emitInvokeVirtual(MethodVisitor asm, Method method) {
        assert (!Modifier.isStatic(method.getModifiers()));
        assert (!method.getDeclaringClass().isInterface());
        asm.visitMethodInsn(182, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    public static void emitInvokeFunction(MethodVisitor asm, String internalClassName, int funcId, FunctionType functionType) {
        asm.visitMethodInsn(184, internalClassName, CompilerUtil.methodNameForFunc(funcId), CompilerUtil.methodTypeFor(functionType).toMethodDescriptorString(), false);
    }

    public static String valueMethodName(List<ValType> types) {
        return "value_" + types.stream().map(type -> type.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining("_"));
    }

    public static String methodNameForFunc(int funcId) {
        return "func_" + funcId;
    }

    static String callMethodName(int funcId) {
        return "call_" + funcId;
    }

    public static String callIndirectMethodName(int typeId) {
        return "call_indirect_" + typeId;
    }

    public static String internalClassName(String name) {
        return name.replace('.', '/');
    }

    static String classNameForDispatch(String prefix, int id) {
        return prefix + "Dispatch_" + id;
    }

    static String callDispatchMethodName(int start) {
        return "call_dispatch_" + start;
    }

    static String classNameForCallIndirect(String prefix, int typeId, int start) {
        return prefix + "Indirect_" + typeId + "_" + start;
    }

    static {
        try {
            LONG_TO_F32 = Value.class.getMethod("longToFloat", Long.TYPE);
            LONG_TO_F64 = Value.class.getMethod("longToDouble", Long.TYPE);
            F32_TO_LONG = Value.class.getMethod("floatToLong", Float.TYPE);
            F64_TO_LONG = Value.class.getMethod("doubleToLong", Double.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

