/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.embedded.chicory.compiler.internal;

import awildgoose.gooseboy.embedded.chicory.compiler.internal.ClassLoadingCollector;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.Compiler;
import awildgoose.gooseboy.embedded.chicory.compiler.internal.CompilerResult;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.embedded.chicory.runtime.Machine;
import awildgoose.gooseboy.embedded.chicory.wasm.WasmModule;
import java.util.function.Function;

public final class MachineFactory
implements Function<Instance, Machine> {
    private final WasmModule module;
    private final Function<Instance, Machine> factory;

    public MachineFactory(WasmModule module) {
        this.module = module;
        Compiler compiler = Compiler.builder(module).withClassCollectorFactory(ClassLoadingCollector::new).build();
        CompilerResult result = compiler.compile();
        ClassLoadingCollector collector = (ClassLoadingCollector)result.collector();
        this.factory = collector.machineFactory();
    }

    public MachineFactory(WasmModule module, Function<Instance, Machine> factory) {
        this.module = module;
        this.factory = factory;
    }

    @Override
    public Machine apply(Instance instance) {
        if (instance.module() != this.module) {
            throw new IllegalArgumentException("Instance module does not match factory module");
        }
        return this.factory.apply(instance);
    }
}

