/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.embedded.chicory.wasm.types;

import awildgoose.gooseboy.embedded.chicory.wasm.types.FunctionType;
import awildgoose.gooseboy.embedded.chicory.wasm.types.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TypeSection
extends Section {
    private final List<FunctionType> types;

    private TypeSection(List<FunctionType> types) {
        super(1L);
        this.types = List.copyOf(types);
    }

    public FunctionType[] types() {
        return this.types.toArray(new FunctionType[0]);
    }

    public int typeCount() {
        return this.types.size();
    }

    public FunctionType getType(int idx) {
        return this.types.get(idx);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof TypeSection)) {
            return false;
        }
        TypeSection that = (TypeSection)o;
        return Objects.equals(this.types, that.types);
    }

    public int hashCode() {
        return Objects.hashCode(this.types);
    }

    public static final class Builder {
        private final List<FunctionType> types = new ArrayList<FunctionType>();

        private Builder() {
        }

        public List<FunctionType> getTypes() {
            return this.types;
        }

        public Builder addFunctionType(FunctionType functionType) {
            Objects.requireNonNull(functionType, "functionType");
            this.types.add(functionType);
            return this;
        }

        public TypeSection build() {
            return new TypeSection(this.types);
        }
    }
}

