/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.lib;

import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.crate.CrateUtils;
import awildgoose.gooseboy.crate.GooseboyCrate;
import awildgoose.gooseboy.embedded.chicory.annotations.HostModule;
import awildgoose.gooseboy.embedded.chicory.annotations.WasmExport;
import awildgoose.gooseboy.embedded.chicory.runtime.HostFunction;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.lib.Input_ModuleFactory;

@HostModule(value="input")
public final class Input {
    @WasmExport
    public int get_key(Instance instance, int key) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_KEYBOARD)) {
            return 0;
        }
        return Gooseboy.ccb.isKeyDown(key) ? 1 : 0;
    }

    @WasmExport
    public int get_mouse_button(Instance instance, int button) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_MOUSE)) {
            return 0;
        }
        return Gooseboy.ccb.isMouseButtonDown(button) ? 1 : 0;
    }

    @WasmExport
    public int get_mouse_x(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_MOUSE_POS)) {
            return 0;
        }
        return Gooseboy.ccb.getMouseXInFramebuffer();
    }

    @WasmExport
    public int get_mouse_y(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_MOUSE_POS)) {
            return 0;
        }
        return Gooseboy.ccb.getMouseYInFramebuffer();
    }

    @WasmExport
    public double get_mouse_accumulated_dx(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_MOUSE_POS)) {
            return 0.0;
        }
        return Gooseboy.ccb.getMouseAccumulatedDX();
    }

    @WasmExport
    public double get_mouse_accumulated_dy(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_MOUSE_POS)) {
            return 0.0;
        }
        return Gooseboy.ccb.getMouseAccumulatedDY();
    }

    @WasmExport
    public int is_mouse_grabbed(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_GRAB_MOUSE)) {
            return 0;
        }
        return Gooseboy.ccb.isMouseGrabbed() ? 1 : 0;
    }

    @WasmExport
    public int get_key_code(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_KEYBOARD)) {
            return -1;
        }
        return Gooseboy.ccb.getKeyCode();
    }

    @WasmExport
    public void grab_mouse(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_GRAB_MOUSE)) {
            return;
        }
        Gooseboy.ccb.grabMouse();
    }

    @WasmExport
    public void release_mouse(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.INPUT_GRAB_MOUSE)) {
            return;
        }
        Gooseboy.ccb.releaseMouse();
    }

    public HostFunction[] toHostFunctions() {
        return Input_ModuleFactory.toHostFunctions(this);
    }
}

