/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.lib;

import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.crate.CrateUtils;
import awildgoose.gooseboy.crate.GooseboyCrate;
import awildgoose.gooseboy.embedded.chicory.annotations.HostModule;
import awildgoose.gooseboy.embedded.chicory.annotations.WasmExport;
import awildgoose.gooseboy.embedded.chicory.runtime.HostFunction;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.lib.Storage_ModuleFactory;

@HostModule(value="storage")
public class Storage {
    @WasmExport
    public int storage_read(Instance instance, int offset, int ptr, int len) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.STORAGE_READ)) {
            return 0;
        }
        return Gooseboy.getCrate((Instance)instance).storage.read(instance.memory(), offset, ptr, len);
    }

    @WasmExport
    public int storage_write(Instance instance, int offset, int ptr, int len) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.STORAGE_WRITE)) {
            return 0;
        }
        return Gooseboy.getCrate((Instance)instance).storage.write(instance.memory(), offset, ptr, len);
    }

    @WasmExport
    public int storage_size(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.STORAGE_READ)) {
            return 0;
        }
        return Gooseboy.getCrate((Instance)instance).storage.size();
    }

    @WasmExport
    public void storage_clear(Instance instance) {
        if (CrateUtils.doesNotHavePermission(instance, GooseboyCrate.Permission.STORAGE_WRITE)) {
            return;
        }
        Gooseboy.getCrate((Instance)instance).storage.clear();
    }

    public HostFunction[] toHostFunctions() {
        return Storage_ModuleFactory.toHostFunctions(this);
    }
}

