/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy.screen;

import awildgoose.gooseboy.crate.GooseboyCrate;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class CenteredCrateScreen
extends class_437 {
    private static final class_2960 SCREEN_UI_LOCATION = class_2960.method_60655((String)"gooseboy", (String)"textures/gui/wasm.png");
    public static final int IMAGE_WIDTH = 330;
    public static final int IMAGE_HEIGHT = 214;
    private static final int GUI_PADDING = 20;
    private static final int INSET_PIXELS = 5;
    private final GooseboyCrate crate;
    private final class_2960 framebufferTexture;
    private class_1043 texture;
    private ByteBuffer tmpBuf;
    private boolean failed = false;
    private long lastRenderNano = 0L;
    private final long frameIntervalNano;

    public CenteredCrateScreen(GooseboyCrate crate) {
        super((class_2561)class_2561.method_43470((String)crate.name));
        this.crate = crate;
        this.frameIntervalNano = 1000000000L / (long)((Integer)class_310.method_1551().field_1690.method_42524().method_41753()).intValue();
        this.framebufferTexture = class_2960.method_60655((String)"gooseboy", (String)("crate_framebuffer_" + crate.name));
    }

    protected void method_25426() {
        this.texture = new class_1043("Gooseboy crate framebuffer", 320, 200, false);
        class_310.method_1551().method_1531().method_4616(this.framebufferTexture, (class_1044)this.texture);
        this.tmpBuf = MemoryUtil.memAlloc((int)this.crate.fbSize);
    }

    public void method_25419() {
        if (this.tmpBuf != null) {
            MemoryUtil.memFree((Buffer)this.tmpBuf);
            this.tmpBuf = null;
        }
        this.texture.close();
        class_310.method_1551().method_1531().method_4615(this.framebufferTexture);
        this.crate.close();
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_73150() {
        return true;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        long now = System.nanoTime();
        this.updateTextureIfNeeded(now);
        Layout layout = Layout.forSize(this.field_22789, this.field_22790);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.texture.method_71659());
        guiGraphics.method_25290(class_10799.field_56883, this.framebufferTexture, layout.fbX, layout.fbY, 0.0f, 0.0f, layout.fbDestWidth, layout.fbDestHeight, layout.fbDestWidth, layout.fbDestHeight);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        Layout layout = Layout.forSize(this.field_22789, this.field_22790);
        guiGraphics.method_25290(class_10799.field_56883, SCREEN_UI_LOCATION, layout.bgX, layout.bgY, 0.0f, 0.0f, layout.bgWidth, layout.bgHeight, layout.bgWidth, layout.bgHeight);
    }

    private void updateTextureIfNeeded(long now) {
        boolean shouldUpdate;
        boolean bl = shouldUpdate = now - this.lastRenderNano >= this.frameIntervalNano;
        if (!shouldUpdate) {
            return;
        }
        if (this.crate.isOk) {
            this.crate.update();
            byte[] fbBytes = this.crate.getFramebufferBytes();
            if (this.tmpBuf != null) {
                this.tmpBuf.clear();
                this.tmpBuf.put(fbBytes).flip();
                class_1011 pixels = this.texture.method_4525();
                if (pixels != null) {
                    MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)this.tmpBuf), (long)pixels.method_67769(), (long)this.crate.fbSize);
                }
                this.texture.method_4524();
            }
            this.lastRenderNano = now;
        } else if (!this.failed) {
            assert (this.field_22787 != null);
            class_370.method_27024((class_374)this.field_22787.method_1566(), (class_370.class_9037)class_370.class_9037.field_49488, (class_2561)class_2561.method_43470((String)"Crate aborted during update"), (class_2561)class_2561.method_43470((String)"Check the console for more information."));
            this.failed = true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record Layout(double scale, int bgWidth, int bgHeight, int bgX, int bgY, int fbDestWidth, int fbDestHeight, int inset, int fbX, int fbY) {
        static Layout forSize(int guiWidth, int guiHeight) {
            double availableW = Math.max(1, guiWidth - 20);
            double availableH = Math.max(1, guiHeight - 20);
            double scale = Math.min(availableW / 330.0, availableH / 214.0);
            int bgWidth = (int)Math.round(330.0 * scale);
            int bgHeight = (int)Math.round(214.0 * scale);
            int bgX = (guiWidth - bgWidth) / 2;
            int bgY = (guiHeight - bgHeight) / 2;
            int fbDestWidth = (int)Math.round(320.0 * scale);
            int fbDestHeight = (int)Math.round(200.0 * scale);
            int inset = (int)Math.round(5.0 * scale);
            int fbX = bgX + inset;
            int fbY = bgY + inset;
            return new Layout(scale, bgWidth, bgHeight, bgX, bgY, fbDestWidth, fbDestHeight, inset, fbX, fbY);
        }
    }
}

