package awildgoose.gooseboy;

import awildgoose.gooseboy.screen.WasmScreen;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import net.minecraft.class_310;

public class WasmInputManager {
	private static final boolean[] keys = new boolean[GLFW.GLFW_KEY_LAST + 1];
	private static final Queue<Integer> keyQueue = new ArrayDeque<>();

	public static void update() {
		long window = class_310.method_1551().method_22683().method_4490();

		for (int i = 32; i <= GLFW.GLFW_KEY_LAST; i++) {
			boolean down = GLFW.glfwGetKey(window, i) == GLFW.GLFW_PRESS;
			if (down && !keys[i]) {
				keyQueue.add(i);
			}
			keys[i] = down;
		}
	}

	public static int getKeyCode() {
		Integer key = keyQueue.poll();
		return key != null ? key : -1;
	}

	public static boolean isKeyDown(int key) {
		return key >= 32 && key <= GLFW.GLFW_KEY_LAST && keys[key];
	}

	public static void reset() {
		keyQueue.clear();
		Arrays.fill(keys, false);
	}

	public static boolean isMouseButtonDown(int button) {
		long window = class_310.method_1551().method_22683().method_4490();
		return GLFW.glfwGetMouseButton(window, button) == GLFW.GLFW_PRESS;
	}

	public static int getMouseXInFramebuffer() {
		int width = class_310.method_1551().method_22683().method_4480() / 2;
		double mouseX =
				class_310.method_1551().field_1729.method_1603() * (double) width / (double)class_310.method_1551().method_22683().method_4480();
		int fbX = (int)(mouseX - (((width - WasmScreen.IMAGE_WIDTH) / 2) + 5));
		if (fbX < 0) fbX = 0;
		if (fbX >= Gooseboy.FRAMEBUFFER_WIDTH) fbX = Gooseboy.FRAMEBUFFER_WIDTH - 1;
		return fbX;
	}

	public static int getMouseYInFramebuffer() {
		int height = class_310.method_1551().method_22683().method_4507() / 2;
		double mouseY =
				class_310.method_1551().field_1729.method_1604() * (double) height / (double) class_310.method_1551().method_22683().method_4507();
		int fbY = (int)(mouseY - (((height - WasmScreen.IMAGE_HEIGHT) / 2) + 5));
		if (fbY < 0) fbY = 0;
		if (fbY >= Gooseboy.FRAMEBUFFER_HEIGHT) fbY = Gooseboy.FRAMEBUFFER_HEIGHT - 1;
		return fbY;
	}
}
