package awildgoose.gooseboy.lib;


import awildgoose.gooseboy.Gooseboy;
import com.dylibso.chicory.annotations.HostModule;
import com.dylibso.chicory.annotations.WasmExport;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.Instance;

@HostModule("framebuffer")
public final class Framebuffer {
	public Framebuffer() {}

	@WasmExport
	public int get_framebuffer_width() {
		return Gooseboy.FRAMEBUFFER_WIDTH;
	}

	@WasmExport
	public int get_framebuffer_height() {
		return Gooseboy.FRAMEBUFFER_HEIGHT;
	}

	@WasmExport
	public void clear_framebuffer(Instance instance, int color) {
		Gooseboy.getCrate(instance).clearFramebuffer(color);
	}

	public HostFunction[] toHostFunctions() {
		return Framebuffer_ModuleFactory.toHostFunctions(this);
	}
}
