package awildgoose.gooseboy.screen;

import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.RawAudioManager;
import awildgoose.gooseboy.crate.WasmCrate;
import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.system.MemoryUtil;

import java.nio.ByteBuffer;
import net.minecraft.class_1043;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_370;
import net.minecraft.class_437;

import static awildgoose.gooseboy.Gooseboy.FRAMEBUFFER_HEIGHT;
import static awildgoose.gooseboy.Gooseboy.FRAMEBUFFER_WIDTH;

public class WasmScreen extends class_437 {
	private static final class_2960 SCREEN_UI_LOCATION = class_2960.method_60655(
			Gooseboy.MOD_ID, "textures/gui/wasm.png");
	// TODO if multiple crates are running at the same time, wouldn't this break?
	private static final class_2960 FRAMEBUFFER_TEXTURE = class_2960.method_60655(
			Gooseboy.MOD_ID, "crate_framebuffer"
	);

	public static final int IMAGE_WIDTH = 330;
	public static final int IMAGE_HEIGHT = 256;

	private final WasmCrate crate;
	private class_1043 texture;
	private ByteBuffer tmpBuf;

	private boolean failed = false;

	private long lastRenderNano = 0L;
	private final long frameIntervalNano;

	public WasmScreen(WasmCrate crate) {
		super(class_2561.method_43470(crate.name));
		this.crate = crate;
		// Should we *really* use the frame limit option here?
		this.frameIntervalNano = 1_000_000_000L / class_310.method_1551().field_1690.method_42524().method_41753();
	}

	@Override
	protected void method_25426() {
		this.texture = new class_1043("Gooseboy crate framebuffer", FRAMEBUFFER_WIDTH, FRAMEBUFFER_HEIGHT, false);
		class_310.method_1551().method_1531().method_4616(FRAMEBUFFER_TEXTURE, this.texture);
		this.tmpBuf = MemoryUtil.memAlloc(this.crate.fbSize);
	}

	@Override
	public boolean method_25421() {
		return false;
	}

	@Override
	public boolean method_73150() {
		return true;
	}

	@Override
	public void method_25394(class_332 guiGraphics, int i, int j, float f) {
		super.method_25394(guiGraphics, i, j, f);

		long now = System.nanoTime();
		boolean shouldUpdate = (now - lastRenderNano) >= this.frameIntervalNano;

		if (shouldUpdate) {
			if (this.crate.isOk) {
				this.crate.update();

				byte[] fbBytes = this.crate.getFramebufferBytes();
				tmpBuf.clear();
				tmpBuf.put(fbBytes).flip();

				var pixels = this.texture.method_4525();
				if (pixels != null)
					MemoryUtil.memCopy(MemoryUtil.memAddress(tmpBuf), pixels.method_67769(), this.crate.fbSize);

				texture.method_4524();
				lastRenderNano = now;
			} else if (!failed) {
				assert field_22787 != null;
				class_370.method_27024(field_22787.method_1566(), class_370.class_9037.field_49488,
								class_2561.method_43470("Crate aborted during update"), class_2561.method_43470("Check the " +
																											"console for more information."));
				failed = true;
			}
		}

		RenderSystem.setShaderTexture(0, texture.method_71659());
		int x = ((this.field_22789 - IMAGE_WIDTH) / 2) + 5;
		int y = ((this.field_22790 - IMAGE_HEIGHT) / 2) + 5;
		guiGraphics.method_25290(class_10799.field_56883, FRAMEBUFFER_TEXTURE, x, y, 0, 0,
						 FRAMEBUFFER_WIDTH,
						 FRAMEBUFFER_HEIGHT,
						 FRAMEBUFFER_WIDTH,
						 FRAMEBUFFER_HEIGHT);
	}

	@Override
	public void method_25419() {
		if (this.tmpBuf != null) {
			MemoryUtil.memFree(this.tmpBuf);
			this.tmpBuf = null;
		}
		this.texture.close();
		this.crate.close();
		RawAudioManager.stopAllSounds();
		super.method_25419();
	}

	@Override
	public void method_25420(class_332 guiGraphics, int i, int j, float f) {
		super.method_25420(guiGraphics, i, j, f);
		int k = (this.field_22789 - IMAGE_WIDTH) / 2;
		int l = (this.field_22790 - IMAGE_HEIGHT) / 2;
		guiGraphics.method_25290(
				class_10799.field_56883, SCREEN_UI_LOCATION,
				k, l,
				0, 0, IMAGE_WIDTH, IMAGE_HEIGHT,
						 IMAGE_WIDTH, IMAGE_HEIGHT);
	}
}
