package awildgoose.gooseboy.screen.widgets;

import awildgoose.gooseboy.ConfigManager;
import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.Wasm;
import awildgoose.gooseboy.WasmInputManager;
import awildgoose.gooseboy.crate.WasmCrate;
import awildgoose.gooseboy.screen.WasmScreen;
import awildgoose.gooseboy.screen.WasmSettingsScreen;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_370;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;

public class WasmSelectionList extends class_4280<WasmSelectionList.Entry> {
	public WasmSelectionList(class_437 parent, class_310 minecraft, int i, int j, int k, int l) {
		super(minecraft, i, j, k, l);
		Wasm.listWasmScripts().forEach(f -> this.method_25321(new Entry(parent, minecraft, this, f)));
	}

	@Override
	public int method_25322() {
		return 270;
	}

	@Override
	public boolean method_25404(class_11908 keyEvent) {
		return super.method_25404(keyEvent);
	}

	public static class Entry extends class_4280.class_4281<WasmSelectionList.Entry> {
		private static final class_2960 WASM_ICON = class_2960.method_60655(
				Gooseboy.MOD_ID, "textures/gui/wasm_icon.png");
		private final class_7842 text;
		private final class_344 runButton;
		private final class_344 settingsButton;

		public Entry(class_437 parent, class_310 minecraft, WasmSelectionList list, String text) {
			int i = list.method_25322() - this.getTextX() - 2;
			class_2561 component = class_2561.method_43470(text);
			this.text = new class_7842(component, minecraft.field_1772);
			this.text.method_73396(i);

			this.runButton = new class_344(0, 0, 15, 15, new class_8666(
					class_2960.method_60655(Gooseboy.MOD_ID, "widget/run_button"),
					class_2960.method_60655(Gooseboy.MOD_ID, "widget/run_button_highlighted")
			), (b) -> {
				// run
				var permissions = ConfigManager.getEffectivePermissions(text);
				var instance = Wasm.createInstance(text,
												   permissions.contains(WasmCrate.Permission.EXTENDED_MEMORY) ?
														   64 * 1024
														   : 8 * 1024);
				if (instance == null) {
					class_370.method_27024(minecraft.method_1566(), class_370.class_9037.field_49488,
									class_2561.method_43470("Failed to load crate"), class_2561.method_43470("Check the " +
																											  "console for more information."));
					return;
				}

				WasmInputManager.reset();
				WasmCrate crate = null;
				try {
					crate = new WasmCrate(instance, text);
				} catch (Throwable e) {
					class_370.method_27024(minecraft.method_1566(), class_370.class_9037.field_49488,
									class_2561.method_43470("Failed to start crate"), class_2561.method_43470("Check the " +
																											  "console for more information."));
					e.printStackTrace();
				}

				if (crate != null) {
					if (crate.isOk) {
						minecraft.method_1507(new WasmScreen(crate));
					} else {
						class_370.method_27024(minecraft.method_1566(), class_370.class_9037.field_49488,
										class_2561.method_43470("Crate aborted upon startup"),
										class_2561.method_43470("Check the " +
																  "console for more information."));
					}
				}
			});

			this.settingsButton = new class_344(0, 0, 15, 15, new class_8666(
					class_2960.method_60655(Gooseboy.MOD_ID, "widget/settings_button"),
					class_2960.method_60655(Gooseboy.MOD_ID, "widget/settings_button_highlighted")
			), (b) -> {
				// settings
				minecraft.method_1507(new WasmSettingsScreen(parent, text));
			});
		}

		@Override
		public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
			if (this.settingsButton.method_25402(mouseButtonEvent, bl)) return true;
			if (this.runButton.method_25402(mouseButtonEvent, bl)) return true;
			return super.method_25402(mouseButtonEvent, bl);
		}

		@Override
		public boolean method_25406(class_11909 mouseButtonEvent) {
			if (this.settingsButton.method_25406(mouseButtonEvent)) return true;
			if (this.runButton.method_25406(mouseButtonEvent)) return true;
			return super.method_25406(mouseButtonEvent);
		}

		@Override
		public int method_25364() {
			return 16 + 1;
		}

		private int getTextX() {
			return this.method_73380() + 16 + 4;
		}

		@Override
		public @NotNull class_2561 method_37006() {
			return this.text.method_25369();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
			int contentX = this.method_73380();
			int contentY = this.method_73382() + 1;
			int centeredY = contentY - 2;
			guiGraphics.method_25290(class_10799.field_56883, WASM_ICON, contentX, centeredY, 0, 0, 15, 15, 15, 15);
			int k = this.getTextX();
			this.text.method_48229(k, contentY);
			this.text.method_25394(guiGraphics, i, j, f);

			// the lock icon
			this.settingsButton.method_48229(method_73389() - 16, centeredY);
			this.settingsButton.method_25394(guiGraphics, i, j, f);

			// the checkbox icon
			this.runButton.method_48229(method_73389() - 16 - 16 - 2, centeredY);
			this.runButton.method_25394(guiGraphics, i, j, f);
		}
	}
}
