package awildgoose.gooseboy.screen.widgets;

import awildgoose.gooseboy.ConfigManager;
import awildgoose.gooseboy.crate.CrateStorage;
import awildgoose.gooseboy.crate.WasmCrate;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_4286;
import net.minecraft.class_7842;

public class WasmSettingsList extends class_4280<WasmSettingsList.Entry> {
	public List<WasmCrate.Permission> permissions;

	public static String formatBytes(long bytes) {
		if (bytes < 1024) return bytes + " B";

		final String[] units = {"B", "KB", "MB", "GB", "TB", "PB"};
		int unitIndex = 0;
		double value = bytes;

		while (value >= 1024 && unitIndex < units.length - 1) {
			value /= 1024;
			unitIndex++;
		}

		if (value % 1 == 0) {
			return String.format("%.0f %s", value, units[unitIndex]);
		} else {
			return String.format("%.1f %s", value, units[unitIndex]);
		}
	}

	public WasmSettingsList(class_310 minecraft, int i, int j, int k, int l, String crateName) {
		super(minecraft, i, j, k, l);
		this.permissions = new ArrayList<>(ConfigManager.getEffectivePermissions(crateName));
		this.method_25321(new TextEntry(minecraft, this,
									"Allocated storage: %s".formatted(formatBytes(CrateStorage.getSizeOf(crateName)))));
		this.method_25321(new TextEntry(minecraft, this, "Permissions"));
		for (WasmCrate.Permission permission : WasmCrate.Permission.values()) {
			String name = permission.name()
					.replace("_", " ");
			String title = Character.toUpperCase(name.charAt(0)) + name.substring(1)
					.toLowerCase();
			this.method_25321(new BooleanEntry(minecraft, this, title, permissions.contains(permission),
										   (checkbox, bl) -> {
											   if (bl) {
												   this.permissions.add(permission);
											   } else {
												   this.permissions.remove(permission);
											   }
										   }));
		}
	}

	@Override
	public int method_25322() {
		return 270;
	}

	@Override
	public boolean method_25404(class_11908 keyEvent) {
		return super.method_25404(keyEvent);
	}

	public abstract static class Entry extends class_4280.class_4281<WasmSettingsList.Entry> {
		public WasmSettingsList list;

		public Entry(class_310 ignoredMinecraft, WasmSettingsList list, String ignoredText) {
			this.list = list;
		}

		@Override
		public int method_25364() {
			return 16 + 2;
		}

		@Override
		public @NotNull class_2561 method_37006() {
			return class_2561.method_43473();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
		}
	}

	public static class TextEntry extends Entry {
		private final class_7842 text;

		public TextEntry(class_310 minecraft, WasmSettingsList list, String text) {
			super(minecraft, list, text);
			int i = list.method_25322() - this.getTextX() - 2;
			class_2561 component = class_2561.method_43470(text);
			this.text = new class_7842(component, minecraft.field_1772);
			this.text.method_73396(i);
		}

		private int getTextX() {
			return this.method_73380() + 16 + 4;
		}

		@Override
		public @NotNull class_2561 method_37006() {
			return this.text.method_25369();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
			super.method_25343(guiGraphics, i, j, bl, f);
			int contentY = this.method_73382() + 1;
			int k = this.getTextX();
			this.text.method_48229(k, contentY);
			this.text.method_25394(guiGraphics, i, j, f);
		}
	}

	public static class BooleanEntry extends Entry {
		private final class_4286 checkbox;

		public BooleanEntry(class_310 minecraft, WasmSettingsList list, String text, boolean checked,
							class_4286.class_8930 callback) {
			super(minecraft, list, text);
			checkbox =
					class_4286.method_54787(class_2561.method_43470(text), minecraft.field_1772)
							.method_54794(checked)
							.method_54791(callback)
							.method_54788();
		}

		@Override
		public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
			if (this.checkbox.method_25402(mouseButtonEvent, bl)) return true;
			return super.method_25402(mouseButtonEvent, bl);
		}

		@Override
		public boolean method_25406(class_11909 mouseButtonEvent) {
			if (this.checkbox.method_25406(mouseButtonEvent)) return true;
			return super.method_25406(mouseButtonEvent);
		}

		@Override
		public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
			super.method_25343(guiGraphics, i, j, bl, f);
			int contentX = this.method_73380();
			int contentY = this.method_73382() + 1;
			int centeredY = contentY - 2;

			checkbox.method_48229(contentX, centeredY);
			checkbox.method_25394(guiGraphics, i, j, f);
		}
	}
}
