/*
 * Decompiled with CFR 0.152.
 */
package net.gamingkaetzchen.combatlog;

import net.gamingkaetzchen.combatlog.CombatManager;
import net.gamingkaetzchen.combatlog.command.CombatLogCommand;
import net.gamingkaetzchen.combatlog.data.BanStorage;
import net.gamingkaetzchen.combatlog.listener.CombatListener;
import net.gamingkaetzchen.combatlog.metrics.MetricsInitializer;
import net.gamingkaetzchen.combatlog.webhook.WebhookClient;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CombatLog
extends JavaPlugin {
    private static CombatLog instance;
    private CombatManager combatManager;
    private BanStorage banStorage;
    private WebhookClient webhook;

    public static CombatLog getInstance() {
        return instance;
    }

    public CombatManager getCombatManager() {
        return this.combatManager;
    }

    public BanStorage getBanStorage() {
        return this.banStorage;
    }

    public WebhookClient getWebhook() {
        return this.webhook;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        MetricsInitializer.init(this);
        this.webhook = new WebhookClient(this);
        this.banStorage = new BanStorage(this);
        this.banStorage.load();
        this.combatManager = new CombatManager(this);
        this.combatManager.startActionbarTask();
        this.getCommand("combatlog").setExecutor((CommandExecutor)new CombatLogCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new CombatListener(this), (Plugin)this);
        this.getLogger().info("CombatLog aktiviert.");
    }

    public void onDisable() {
        if (this.combatManager != null) {
            this.combatManager.shutdown();
        }
        if (this.banStorage != null) {
            this.banStorage.save();
        }
        this.getLogger().info("CombatLog deaktiviert.");
    }

    public void reloadEverything() {
        this.reloadConfig();
        this.webhook.reload();
        this.banStorage.save();
    }
}

