/*
 * Decompiled with CFR 0.152.
 */
package net.gamingkaetzchen.combatlog;

import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.gamingkaetzchen.combatlog.CombatLog;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatManager {
    private final CombatLog plugin;
    private final Map<UUID, Long> combatUntil = new ConcurrentHashMap<UUID, Long>();
    private final MiniMessage mm = MiniMessage.miniMessage();
    private BukkitRunnable task;

    public CombatManager(CombatLog plugin) {
        this.plugin = plugin;
    }

    public int getCombatSeconds() {
        return Math.max(1, this.plugin.getConfig().getInt("combat-duration-seconds", 15));
    }

    public boolean isInCombat(UUID uuid) {
        Long until = this.combatUntil.get(uuid);
        return until != null && until > System.currentTimeMillis();
    }

    public long getMillisLeft(UUID uuid) {
        Long until = this.combatUntil.get(uuid);
        if (until == null) {
            return 0L;
        }
        return Math.max(0L, until - System.currentTimeMillis());
    }

    public int getSecondsLeft(UUID uuid) {
        return (int)Math.ceil((double)this.getMillisLeft(uuid) / 1000.0);
    }

    public void tag(Player ... players) {
        long until = System.currentTimeMillis() + (long)this.getCombatSeconds() * 1000L;
        for (Player p : players) {
            if (p == null || p.hasPermission(this.plugin.getConfig().getString("bypass-permission", "combatlog.bypass")) || this.shouldIgnoreGamemode(p.getGameMode())) continue;
            boolean firstTime = !this.isInCombat(p.getUniqueId());
            this.combatUntil.put(p.getUniqueId(), until);
            if (!firstTime) continue;
            String msg = this.plugin.getConfig().getString("messages.tagged", "<yellow>Combat gestartet: %seconds%s</yellow>");
            p.sendMessage(this.mm.deserialize((Object)msg.replace("%seconds%", String.valueOf(this.getCombatSeconds()))));
        }
        if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("tag-start")) {
            String names = Arrays.stream(players).filter(Objects::nonNull).map(Player::getName).distinct().reduce((a, b) -> a + ", " + b).orElse("");
            this.plugin.getWebhook().sendSimple("tag-start", "Combat gestartet: " + names);
        }
    }

    public void clear(UUID uuid) {
        this.combatUntil.remove(uuid);
    }

    public void clear(Player p) {
        if (p != null) {
            this.clear(p.getUniqueId());
        }
    }

    public void startActionbarTask() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<UUID, Long>> it = CombatManager.this.combatUntil.entrySet().iterator();
                while (it.hasNext()) {
                    Player p;
                    Map.Entry<UUID, Long> e = it.next();
                    UUID uuid = e.getKey();
                    long left = e.getValue() - System.currentTimeMillis();
                    if (left <= 0L) {
                        it.remove();
                        p = Bukkit.getPlayer((UUID)uuid);
                        if (p == null || !p.isOnline()) continue;
                        String msg = CombatManager.this.plugin.getConfig().getString("messages.now-safe", "<green>Du bist nicht mehr im Kampf.</green>");
                        p.sendMessage(CombatManager.this.mm.deserialize((Object)msg));
                        continue;
                    }
                    p = Bukkit.getPlayer((UUID)uuid);
                    if (p == null || !p.isOnline()) continue;
                    int s = (int)Math.ceil((double)left / 1000.0);
                    String ab = CombatManager.this.plugin.getConfig().getString("actionbar-format", "<red>Combat: </red><white>%seconds%s</white>").replace("%seconds%", String.valueOf(s));
                    p.sendActionBar(CombatManager.this.mm.deserialize((Object)ab));
                }
            }
        };
        this.task.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void shutdown() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.combatUntil.clear();
    }

    public String formatDuration(long seconds) {
        Duration d = Duration.ofSeconds(Math.max(0L, seconds));
        long h = d.toHours();
        long m = d.minusHours(h).toMinutes();
        long s = d.minusHours(h).minusMinutes(m).getSeconds();
        if (h > 0L) {
            return String.format("%dh %dm %ds", h, m, s);
        }
        if (m > 0L) {
            return String.format("%dm %ds", m, s);
        }
        return String.format("%ds", s);
    }

    private boolean shouldIgnoreGamemode(GameMode gm) {
        List ignore = this.plugin.getConfig().getStringList("ignore-gamemodes");
        return ignore.stream().anyMatch(s -> s.equalsIgnoreCase(gm.name()));
    }
}

