/*
 * Decompiled with CFR 0.152.
 */
package net.gamingkaetzchen.combatlog.command;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import net.gamingkaetzchen.combatlog.CombatLog;
import net.gamingkaetzchen.combatlog.CombatManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CombatLogCommand
implements CommandExecutor,
TabCompleter {
    private final CombatLog plugin;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public CombatLogCommand(CombatLog plugin) {
        this.plugin = plugin;
    }

    private boolean checkPerm(CommandSender s) {
        String perm = this.plugin.getConfig().getString("admin-permission", "combatlog.admin");
        if (!s.hasPermission(perm)) {
            s.sendMessage(this.mm.deserialize((Object)"<red>Keine Berechtigung.</red>"));
            return false;
        }
        return true;
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            s.sendMessage(this.mm.deserialize((Object)"<gray>/combatlog <reload|clear|pardon|ban|info> ...</gray>"));
            return true;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                if (!this.checkPerm(s)) {
                    return true;
                }
                this.plugin.reloadEverything();
                s.sendMessage(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.reloaded", "<green>Reloaded.</green>")));
                if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("reload")) {
                    this.plugin.getWebhook().sendSimple("reload", "Config reloaded by " + s.getName());
                }
                return true;
            }
            case "clear": {
                if (!this.checkPerm(s)) {
                    return true;
                }
                if (args.length < 2) {
                    s.sendMessage(this.mm.deserialize((Object)"<gray>Nutzen: /combatlog clear <player></gray>"));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    s.sendMessage(this.mm.deserialize((Object)"<red>Spieler nicht online.</red>"));
                    return true;
                }
                this.plugin.getCombatManager().clear(target);
                s.sendMessage(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.admin-cleared", "<green>Combat f\u00fcr %player% zur\u00fcckgesetzt.</green>").replace("%player%", target.getName())));
                return true;
            }
            case "pardon": {
                OfflinePlayer cached;
                UUID targetId;
                if (!this.checkPerm(s)) {
                    return true;
                }
                if (args.length < 2) {
                    s.sendMessage(this.mm.deserialize((Object)"<gray>Nutzen: /combatlog pardon <player|uuid></gray>"));
                    return true;
                }
                String input = args[1];
                Player online = Bukkit.getPlayerExact((String)input);
                UUID uUID = targetId = online != null ? online.getUniqueId() : null;
                if (targetId == null) {
                    try {
                        targetId = UUID.fromString(input);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (targetId == null) {
                    targetId = this.plugin.getBanStorage().findUuidByName(input);
                }
                if (targetId == null && (cached = Bukkit.getOfflinePlayerIfCached((String)input)) != null) {
                    targetId = cached.getUniqueId();
                }
                if (targetId == null) {
                    s.sendMessage(this.mm.deserialize((Object)"<red>Spieler/UUID nicht gefunden. Nutze exakten Online-Namen oder eine UUID.</red>"));
                    return true;
                }
                this.plugin.getBanStorage().pardon(targetId);
                this.plugin.getBanStorage().save();
                String display = online != null ? online.getName() : (this.plugin.getBanStorage().getLastKnownName(targetId) != null ? this.plugin.getBanStorage().getLastKnownName(targetId) : input);
                s.sendMessage(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.admin-pardoned", "<green>Sperre f\u00fcr %player% aufgehoben.</green>").replace("%player%", display)));
                if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("ban-pardoned")) {
                    this.plugin.getWebhook().sendSimple("ban-pardoned", "Pardon: " + display);
                }
                return true;
            }
            case "ban": {
                OfflinePlayer cached;
                String displayName;
                long seconds;
                if (!this.checkPerm(s)) {
                    return true;
                }
                if (args.length < 3) {
                    s.sendMessage(this.mm.deserialize((Object)"<gray>Nutzen: /combatlog ban <player|uuid> <seconds> [reason...]</gray>"));
                    return true;
                }
                String input = args[1];
                try {
                    seconds = Long.parseLong(args[2]);
                }
                catch (NumberFormatException ex) {
                    s.sendMessage(this.mm.deserialize((Object)"<red>seconds muss eine Zahl sein.</red>"));
                    return true;
                }
                Player online = Bukkit.getPlayerExact((String)input);
                UUID targetId = online != null ? online.getUniqueId() : null;
                String string = displayName = online != null ? online.getName() : null;
                if (targetId == null) {
                    try {
                        targetId = UUID.fromString(input);
                        displayName = input;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (targetId == null && (targetId = this.plugin.getBanStorage().findUuidByName(input)) != null) {
                    displayName = this.plugin.getBanStorage().getLastKnownName(targetId);
                }
                if (targetId == null && (cached = Bukkit.getOfflinePlayerIfCached((String)input)) != null) {
                    targetId = cached.getUniqueId();
                    displayName = cached.getName();
                }
                if (targetId == null) {
                    s.sendMessage(this.mm.deserialize((Object)"<red>Spieler/UUID nicht gefunden. Nutze exakten Online-Namen oder eine UUID.</red>"));
                    return true;
                }
                long until = System.currentTimeMillis() + Math.max(1L, seconds) * 1000L;
                this.plugin.getBanStorage().setBan(targetId, until, displayName != null ? displayName : input);
                this.plugin.getBanStorage().save();
                if (online != null) {
                    online.kick(this.mm.deserialize((Object)("<red>Combat-Ban</red><gray> (" + seconds + "s)</gray>")));
                }
                String reason = args.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)) : "Admin-Ban";
                s.sendMessage(this.mm.deserialize((Object)("<green>Sperre gesetzt f\u00fcr </green><white>" + (displayName != null ? displayName : input) + "</white><gray> (" + seconds + "s)</gray>")));
                if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("ban-created")) {
                    this.plugin.getWebhook().sendSimple("ban-created", "Ban: " + (displayName != null ? displayName : input) + " (" + seconds + "s) \u2013 " + reason);
                }
                return true;
            }
            case "info": {
                CombatManager m = this.plugin.getCombatManager();
                if (args.length < 2) {
                    if (s instanceof Player) {
                        Player p = (Player)s;
                        boolean in = m.isInCombat(p.getUniqueId());
                        int secs = m.getSecondsLeft(p.getUniqueId());
                        s.sendMessage(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.info", "<gray>%player%</gray> ist %state% (Rest: %seconds%s).").replace("%player%", p.getName()).replace("%state%", in ? "<red>IM KAMPF</red>" : "<green>SAFE</green>").replace("%seconds%", String.valueOf(secs))));
                        return true;
                    }
                    s.sendMessage(this.mm.deserialize((Object)"<gray>Nutzen: /combatlog info <player></gray>"));
                    return true;
                }
                Player t = Bukkit.getPlayer((String)args[1]);
                if (t == null) {
                    s.sendMessage(this.mm.deserialize((Object)"<red>Spieler nicht online.</red>"));
                    return true;
                }
                boolean in = m.isInCombat(t.getUniqueId());
                int secs = m.getSecondsLeft(t.getUniqueId());
                s.sendMessage(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.info", "<gray>%player%</gray> ist %state% (Rest: %seconds%s).").replace("%player%", t.getName()).replace("%state%", in ? "<red>IM KAMPF</red>" : "<green>SAFE</green>").replace("%seconds%", String.valueOf(secs))));
                return true;
            }
        }
        s.sendMessage(this.mm.deserialize((Object)"<gray>/combatlog <reload|clear|pardon|ban|info></gray>"));
        return true;
    }

    public List<String> onTabComplete(CommandSender s, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return List.of("reload", "clear", "pardon", "ban", "info");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("pardon")) {
            String typed = args[1].toLowerCase(Locale.ROOT);
            return this.plugin.getBanStorage().getActiveBanSuggestions().stream().filter(x -> x.toLowerCase(Locale.ROOT).startsWith(typed)).limit(100L).collect(Collectors.toList());
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("clear") || args[0].equalsIgnoreCase("ban") || args[0].equalsIgnoreCase("info"))) {
            String typed = args[1].toLowerCase(Locale.ROOT);
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(n -> n.toLowerCase(Locale.ROOT).startsWith(typed)).collect(Collectors.toList());
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("ban")) {
            return List.of("300", "600", "900");
        }
        return List.of();
    }
}

