/*
 * Decompiled with CFR 0.152.
 */
package net.gamingkaetzchen.combatlog.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.gamingkaetzchen.combatlog.CombatLog;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BanStorage {
    private final CombatLog plugin;
    private File file;
    private FileConfiguration cfg;

    public BanStorage(CombatLog plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.file = new File(this.plugin.getDataFolder(), "bans.yml");
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.cfg.isConfigurationSection("bans")) {
            this.cfg.createSection("bans");
        }
        this.save();
    }

    public void save() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save bans.yml: " + e.getMessage());
        }
    }

    public void setBan(UUID uuid, long untilEpochMillis, String name) {
        String base = "bans." + String.valueOf(uuid);
        this.cfg.set(base + ".until", (Object)untilEpochMillis);
        if (name != null && !name.isBlank()) {
            this.cfg.set(base + ".name", (Object)name);
        }
    }

    public void setBan(UUID uuid, long untilEpochMillis) {
        this.setBan(uuid, untilEpochMillis, null);
    }

    public boolean isBanned(UUID uuid) {
        long now = System.currentTimeMillis();
        long until = this.getUntil(uuid);
        return until > now;
    }

    public long getMillisLeft(UUID uuid) {
        long now = System.currentTimeMillis();
        long until = this.getUntil(uuid);
        return Math.max(0L, until - now);
    }

    public void pardon(UUID uuid) {
        this.cfg.set("bans." + String.valueOf(uuid), null);
    }

    public String getLastKnownName(UUID uuid) {
        return this.cfg.getString("bans." + String.valueOf(uuid) + ".name", null);
    }

    public UUID findUuidByName(String name) {
        ConfigurationSection sec = this.cfg.getConfigurationSection("bans");
        if (sec == null) {
            return null;
        }
        Set keys = sec.getKeys(false);
        for (String k : keys) {
            String n = this.cfg.getString("bans." + k + ".name", null);
            if (n == null || !n.equalsIgnoreCase(name)) continue;
            try {
                return UUID.fromString(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    public List<String> getActiveBanSuggestions() {
        ConfigurationSection sec = this.cfg.getConfigurationSection("bans");
        if (sec == null) {
            return List.of();
        }
        long now = System.currentTimeMillis();
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        for (String k : sec.getKeys(false)) {
            UUID uuid;
            try {
                uuid = UUID.fromString(k);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            long until = this.getUntil(uuid);
            if (until <= now) continue;
            String name = this.cfg.getString("bans." + k + ".name", null);
            if (name != null && !name.isBlank()) {
                out.add(name);
            }
            out.add(k);
        }
        return new ArrayList<String>(out);
    }

    private long getUntil(UUID uuid) {
        Object v = this.cfg.get("bans." + String.valueOf(uuid));
        if (v instanceof Number) {
            Number num = (Number)v;
            return num.longValue();
        }
        return this.cfg.getLong("bans." + String.valueOf(uuid) + ".until", 0L);
    }
}

