/*
 * Decompiled with CFR 0.152.
 */
package net.gamingkaetzchen.combatlog.listener;

import java.util.Locale;
import net.gamingkaetzchen.combatlog.CombatLog;
import net.gamingkaetzchen.combatlog.CombatManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.projectiles.ProjectileSource;

public class CombatListener
implements Listener {
    private final CombatLog plugin;
    private final CombatManager manager;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public CombatListener(CombatLog plugin) {
        this.plugin = plugin;
        this.manager = plugin.getCombatManager();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Player attacker = null;
        Entity entity2 = e.getDamager();
        if (entity2 instanceof Player) {
            Player p;
            attacker = p = (Player)entity2;
        } else {
            Projectile proj;
            ProjectileSource src;
            entity2 = e.getDamager();
            if (entity2 instanceof Projectile && (src = (proj = (Projectile)entity2).getShooter()) instanceof Player) {
                Player p;
                attacker = p = (Player)src;
            }
        }
        if (attacker == null || attacker.equals((Object)victim)) {
            return;
        }
        this.manager.tag(attacker, victim);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        Player p = e.getPlayer();
        if (p.hasPermission(this.plugin.getConfig().getString("bypass-permission", "combatlog.bypass"))) {
            return;
        }
        if (!this.manager.isInCombat(p.getUniqueId())) {
            return;
        }
        String message = e.getMessage().trim();
        if (!message.startsWith("/")) {
            return;
        }
        String label = message.substring(1).split("\\s+")[0].toLowerCase(Locale.ROOT);
        for (String blocked : this.plugin.getConfig().getStringList("blocked-commands")) {
            String b = blocked.toLowerCase(Locale.ROOT).trim();
            if (!label.equals(b)) continue;
            e.setCancelled(true);
            String msg = this.plugin.getConfig().getString("messages.command-blocked", "<red>Du kannst /%cmd% im Kampf nicht nutzen (%seconds%s verbleibend).</red>");
            msg = msg.replace("%cmd%", label).replace("%seconds%", String.valueOf(this.manager.getSecondsLeft(p.getUniqueId())));
            p.sendMessage(this.mm.deserialize((Object)msg));
            if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("command-blocked")) {
                this.plugin.getWebhook().sendSimple("command-blocked", p.getName() + " blockiert: /" + label);
            }
            return;
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        String action;
        Player p = e.getPlayer();
        if (!this.manager.isInCombat(p.getUniqueId())) {
            return;
        }
        if (p.hasPermission(this.plugin.getConfig().getString("bypass-permission", "combatlog.bypass"))) {
            return;
        }
        switch (action = this.plugin.getConfig().getString("logout-action", "only-log").toLowerCase(Locale.ROOT)) {
            case "kill": {
                if (p.getHealth() > 0.0) {
                    p.setHealth(0.0);
                }
                if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("logout-punish")) {
                    this.plugin.getWebhook().sendSimple("logout-punish", p.getName() + " hat im Kampf ausgeloggt: Aktion=KILL");
                }
                this.manager.clear(p);
                break;
            }
            case "temp-ban": {
                int seconds = Math.max(1, this.plugin.getConfig().getInt("temp-ban-seconds", 900));
                long until = System.currentTimeMillis() + (long)seconds * 1000L;
                this.plugin.getBanStorage().setBan(p.getUniqueId(), until, p.getName());
                this.plugin.getBanStorage().save();
                if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("logout-punish")) {
                    this.plugin.getWebhook().sendSimple("logout-punish", p.getName() + " hat im Kampf ausgeloggt: Aktion=TEMP-BAN " + seconds + "s");
                }
                this.manager.clear(p);
                break;
            }
            case "kill-and-ban": 
            case "killban": 
            case "kill+ban": {
                if (p.getHealth() > 0.0) {
                    p.setHealth(0.0);
                }
                int seconds = Math.max(1, this.plugin.getConfig().getInt("temp-ban-seconds", 900));
                long until = System.currentTimeMillis() + (long)seconds * 1000L;
                this.plugin.getBanStorage().setBan(p.getUniqueId(), until, p.getName());
                this.plugin.getBanStorage().save();
                if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("logout-punish")) {
                    this.plugin.getWebhook().sendSimple("logout-punish", p.getName() + " hat im Kampf ausgeloggt: Aktion=KILL+TEMP-BAN " + seconds + "s");
                }
                this.manager.clear(p);
                break;
            }
            default: {
                if (this.plugin.getConfig().getBoolean("discord.enabled", false) && this.plugin.getConfig().getStringList("discord.send-events").contains("logout-punish")) {
                    this.plugin.getWebhook().sendSimple("logout-punish", p.getName() + " hat im Kampf ausgeloggt: Aktion=ONLY-LOG");
                }
                this.manager.clear(p);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (this.manager.isInCombat(p.getUniqueId())) {
            this.manager.clear(p);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLogin(PlayerLoginEvent e) {
        Player p = e.getPlayer();
        if (this.plugin.getBanStorage().isBanned(p.getUniqueId())) {
            long ms = this.plugin.getBanStorage().getMillisLeft(p.getUniqueId());
            if (ms <= 0L) {
                this.plugin.getBanStorage().pardon(p.getUniqueId());
                this.plugin.getBanStorage().save();
                return;
            }
            long seconds = (long)Math.ceil((double)ms / 1000.0);
            String remaining = this.manager.formatDuration(seconds);
            String kick = this.plugin.getConfig().getString("messages.login-still-banned", "Combat-Logging Sperre aktiv. Warte noch %remaining%.").replace("%remaining%", remaining);
            e.disallow(PlayerLoginEvent.Result.KICK_OTHER, MiniMessage.miniMessage().deserialize((Object)kick));
        }
    }
}

