/*
 * Decompiled with CFR 0.152.
 */
package net.gamingkaetzchen.combatlog.webhook;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.gamingkaetzchen.combatlog.CombatLog;

public class WebhookClient {
    private final CombatLog plugin;
    private volatile boolean enabled;
    private volatile String url;
    private volatile String username;
    private final HttpClient client = HttpClient.newHttpClient();

    public WebhookClient(CombatLog plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.enabled = this.plugin.getConfig().getBoolean("discord.enabled", false);
        this.url = this.plugin.getConfig().getString("discord.webhook-url", "");
        this.username = this.plugin.getConfig().getString("discord.username", "CombatLog");
    }

    public void sendSimple(String event, String content) {
        if (!this.enabled || this.url == null || this.url.isBlank()) {
            return;
        }
        String json = "{\n  \"username\": \"%s\",\n  \"content\": \"**[%s]** %s\"\n}\n".formatted(this.escape(this.username), this.escape(event), this.escape(content));
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.client.sendAsync(request, HttpResponse.BodyHandlers.discarding()).exceptionally(ex -> {
            this.plugin.getLogger().warning("Webhook-Fehler: " + ex.getMessage());
            return null;
        });
    }

    private String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

