/*
 * Decompiled with CFR 0.152.
 */
package net.ds;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import net.ds.Utils;
import net.ds.config.BeansUtilsServerConfig;
import net.ds.events.EndTick;
import net.ds.events.ServerStopping;
import net.ds.network.CombatPayload;
import net.ds.network.HandshakePayload;
import net.ds.network.SetHashPayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeansUtils
implements ModInitializer {
    public static final String MOD_ID = "beans-utils";
    public static final String MOD_VERSION = FabricLoader.getInstance().getModContainer("beans-utils").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"beans-utils");
    public static final class_5321<class_8110> COMBAT_LOG_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)BeansUtils.of("combat_log"));
    public static final Map<UUID, Integer> waitingForResponse = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> clientsWithMods = new ConcurrentHashMap<UUID, Boolean>();
    public static final BeansUtilsServerConfig SERVER_CONFIG = (BeansUtilsServerConfig)ConfigApiJava.registerAndLoadConfig(BeansUtilsServerConfig::new, (RegisterType)RegisterType.BOTH);
    public static MinecraftServer SERVER;
    private static final class_2558 CLICK_EVENT;

    public void onInitialize() {
        BeansUtils.registerPayloads();
        BeansUtils.registerEvents();
        Utils.getOrCreateHashFile();
        LOGGER.info("BeansUtils Common initialized ({})", (Object)MOD_VERSION);
    }

    public static class_2960 of(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static void registerEvents() {
        ServerTickEvents.END_SERVER_TICK.register((Object)EndTick.INSTANCE);
        ServerLifecycleEvents.SERVER_STOPPING.register((Object)ServerStopping.INSTANCE);
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            SERVER = minecraftServer;
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && class_310.method_1551().method_1542()) {
            return;
        }
        ServerPlayerEvents.JOIN.register(HandshakePayload::attemptHandshake);
    }

    private static void registerPayloads() {
        PayloadTypeRegistry.playC2S().register(HandshakePayload.HandshakeC2SPayload.ID, HandshakePayload.HandshakeC2SPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(HandshakePayload.HandshakeS2CPayload.ID, HandshakePayload.HandshakeS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CombatPayload.CombatS2CPayload.ID, CombatPayload.CombatS2CPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetHashPayload.SetHashC2SPayload.ID, SetHashPayload.SetHashC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(HandshakePayload.HandshakeC2SPayload.ID, BeansUtils::playerHandshakeRespond);
        ServerPlayNetworking.registerGlobalReceiver(SetHashPayload.SetHashC2SPayload.ID, BeansUtils::setHashC2S);
    }

    public static void setHashC2S(SetHashPayload.SetHashC2SPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        if (!player.method_64475(4)) {
            return;
        }
        try {
            if (Objects.equals(BeansUtils.SERVER_CONFIG.resourcePackSettings.serverResourcePackURL, "")) {
                LOGGER.warn("No custom url set");
                player.method_64398((class_2561)class_2561.method_43470((String)"No custom url set").method_54663(-65536));
                return;
            }
            String url = BeansUtils.SERVER_CONFIG.resourcePackSettings.serverResourcePackURL;
            player.method_64398((class_2561)class_2561.method_43470((String)("Downloading: " + url)).method_54663(-16776961));
            BufferedInputStream inputStream = new BufferedInputStream(new URL(url).openStream());
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            DigestInputStream digestInputStream = new DigestInputStream(inputStream, digest);
            while (digestInputStream.read() != -1) {
            }
            digestInputStream.close();
            LOGGER.info("D");
            LOGGER.info("Resource pack downloaded, calculating hash");
            byte[] hash = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                hexString.append(String.format("%02x", b));
            }
            String hashFinal = hexString.toString().toLowerCase(Locale.ROOT);
            File hashFile = Utils.getOrCreateHashFile();
            FileWriter writer = new FileWriter(hashFile);
            writer.write(hashFinal);
            writer.close();
            player.method_64398((class_2561)class_2561.method_43470((String)("Successfully fetched hash: " + hashFinal)).method_54663(-16711936));
        }
        catch (NoSuchElementException e) {
            LOGGER.error("Could not get resource pack url: {}", (Object)String.valueOf(e));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Invalid resource pack url: {}", (Object)String.valueOf(e));
        }
        catch (IOException e) {
            LOGGER.error("IOException: {}", (Object)String.valueOf(e));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Invalid alg: {}", (Object)String.valueOf(e));
        }
    }

    public static void handshakeServerTick(MinecraftServer server) {
        waitingForResponse.replaceAll((uuid, ticks) -> ticks - 1);
        waitingForResponse.entrySet().removeIf(entry -> {
            class_3222 player;
            UUID uuid = (UUID)entry.getKey();
            int ticksLeft = (Integer)entry.getValue();
            if (ticksLeft <= 0 && (player = server.method_3760().method_14602(uuid)) != null) {
                BeansUtils.playerHandshakeTimeout(player);
                return true;
            }
            return false;
        });
    }

    public static void playerHandshakeTimeout(class_3222 player) {
        LOGGER.info("{} failed to respond to handshake", (Object)Objects.requireNonNull(player.method_5476()).getString());
        waitingForResponse.remove(player.method_5667());
        if (BeansUtils.SERVER_CONFIG.requireMod) {
            player.field_13987.method_52396((class_2561)class_2561.method_43470((String)BeansUtils.SERVER_CONFIG.noModDisconnectMessage).method_27694(style -> {
                style.method_10977(class_124.field_1075);
                style.method_10958(CLICK_EVENT);
                return style;
            }));
            return;
        }
        clientsWithMods.put(player.method_5667(), false);
        if (BeansUtils.SERVER_CONFIG.notifyPlayersWithNoMod) {
            player.method_64398((class_2561)class_2561.method_43470((String)BeansUtils.SERVER_CONFIG.notifyPlayerMessage).method_27694(style -> {
                style.method_10977(class_124.field_1060);
                style.method_30938(Boolean.valueOf(true));
                style.method_10958(CLICK_EVENT);
                return style;
            }));
        }
    }

    public static void playerHandshakeRespond(HandshakePayload.HandshakeC2SPayload payload, ServerPlayNetworking.Context context) {
        String receivedVersion = payload.modVersion();
        class_3222 player = context.player();
        waitingForResponse.remove(player.method_5667());
        if (!Objects.equals(receivedVersion, MOD_VERSION)) {
            LOGGER.info("{} has mismatched client version", (Object)Objects.requireNonNull(player.method_5476()).getString());
            String message = "Outdated/Incorrect BeansUtils mod version (Client Version: %s, Server Version: %s)".formatted(receivedVersion, MOD_VERSION);
            player.field_13987.method_52396(class_2561.method_30163((String)message));
        } else {
            LOGGER.info("{} has successfully joined with matching BeansUtils version!!", (Object)Objects.requireNonNull(player.method_5476()).getString());
            clientsWithMods.put(player.method_5667(), true);
        }
    }

    public static boolean doesPlayerHaveMod(UUID uuid) {
        return clientsWithMods.getOrDefault(uuid, false);
    }

    static {
        CLICK_EVENT = new class_2558.class_10608(URI.create("https://github.com/Destruction-Studios/beans-utils"));
    }
}

