/*
 * Decompiled with CFR 0.152.
 */
package net.ds.config;

import java.util.Map;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Comment;
import me.fzzyhmstrs.fzzy_config.annotations.LiteralString;
import me.fzzyhmstrs.fzzy_config.annotations.MultilineString;
import me.fzzyhmstrs.fzzy_config.annotations.Version;
import me.fzzyhmstrs.fzzy_config.api.FileType;
import me.fzzyhmstrs.fzzy_config.api.SaveType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigAction;
import me.fzzyhmstrs.fzzy_config.config.ConfigGroup;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.util.Translatable;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedIdentifierMap;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.ds.network.SetHashPayload;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Version(version=10)
public class BeansUtilsServerConfig
extends Config {
    public ConfigGroup clientModVerification = new ConfigGroup("clientModVerification");
    @Comment(value="If players without the mod installed will be kicked.")
    public boolean requireMod = false;
    @Comment(value="The kick message a player gets without the mod.")
    @MultilineString
    public String noModDisconnectMessage = "This server requires BeansUtils";
    @Comment(value="The max amount of time a player can not respond before being kicked.")
    public int handshakeTimeout = 200;
    @Comment(value="Send a message to a player without the mod recommending it.")
    public boolean notifyPlayersWithNoMod = false;
    @Comment(value="Message a player without the mod is notified with")
    @MultilineString
    @ConfigGroup.Pop
    public String notifyPlayerMessage = "This server recommends you install BeansUtils for more functionality.";
    public ConfigGroup serverSettings = new ConfigGroup("serverSettings");
    @Comment(value="Settings relating to custom resource packs.")
    public ResourcePackSettings resourcePackSettings = new ResourcePackSettings();
    @Comment(value="Whether or not player vs player combat is enabled.")
    @ConfigGroup.Pop
    public boolean pvpEnabled = true;
    public ConfigGroup vanillaFeatureToggling = new ConfigGroup("vanillaFeatureToggling");
    @Comment(value="Whether or not Nether Portals are disabled.")
    public boolean netherPortalsDisabled = false;
    @Comment(value="Whether or not End Portals are disabled.")
    public boolean endPortalsDisabled = false;
    @Comment(value="Whether or not Eyes of Ender are disabled.")
    @ConfigGroup.Pop
    public boolean eyesOfEnderDisabled = false;
    public ConfigGroup combatTagging = new ConfigGroup("combatTagging");
    @Comment(value="Whether or not combat logging features are enabled")
    public boolean combatTaggingEnabled = false;
    @Comment(value="How long a player is in combat. (Seconds)")
    public ValidatedInt combatDuration = new ValidatedInt(15, 120, 3);
    @Comment(value="Should a player be killed upon combat logging")
    public boolean killPlayerUponCombatLogging = true;
    @Comment(value="What entities cause combat")
    public ValidatedIdentifierMap<Boolean> combatTriggeringEntities = new ValidatedIdentifierMap(Map.of(class_2960.method_60654((String)"player"), true), ValidatedIdentifier.ofRegistry((class_2960)class_2960.method_60654((String)"player"), (class_2378)class_7923.field_41177), (Entry)new ValidatedBoolean(true));
    @ConfigGroup.Pop
    @Comment(value="Features disabled while a player is in combat.")
    public CombatDisabledFeatures combatDisabledFeatures = new CombatDisabledFeatures();

    public BeansUtilsServerConfig() {
        super(class_2960.method_60655((String)"beans-utils", (String)"server_config"));
    }

    public int defaultPermLevel() {
        return 4;
    }

    @NotNull
    public FileType fileType() {
        return FileType.JSON5;
    }

    @NotNull
    public SaveType saveType() {
        return SaveType.SEPARATE;
    }

    public static class ResourcePackSettings
    extends ConfigSection {
        private final Supplier<class_2561> setHashLabel = () -> class_2561.method_30163((String)"Set Hash");
        private final Supplier<Boolean> setHashEnabled = () -> true;
        private final Runnable setHashRunnable = SetHashPayload::requestHashReset;
        @Comment(value="Sets the servers hash to the resource pack set below")
        @Translatable.Prefix(value="!! DO NOT SPAM !!\nCan be used for custom resource packs or resource packs set in 'server.properties'")
        public ConfigAction setHash = new ConfigAction(this.setHashLabel, this.setHashEnabled, this.setHashRunnable, null, null);
        @Comment(value="Whether or not players are send the custom resource pack.")
        public boolean useCustomResourcePack = false;
        @Comment(value="The resource pack of the server.")
        @LiteralString
        public String serverResourcePackURL = "";
    }

    public static class CombatDisabledFeatures
    extends ConfigSection {
        @Comment(value="Are ender pearls disabled in combat")
        public boolean disableEnderPearls = false;
        @Comment(value="Are riptide tridents disabled in combat")
        public boolean disableTridents = false;
        @Comment(value="Are firework rockets disabled in combat")
        public boolean disabledFireworkRockets = false;
    }
}

