/*
 * Decompiled with CFR 0.152.
 */
package net.ds.mixin;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import net.ds.BeansUtils;
import net.ds.Utils;
import net.minecraft.class_2720;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2720.class})
public class ResourcePackMixin {
    @Inject(method={"comp_2160()Ljava/lang/String;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getHash(CallbackInfoReturnable<String> cir) {
        if (!Utils.isResourcePackUrlOverrideSet()) {
            BeansUtils.LOGGER.info("No custom resource pack.");
            return;
        }
        File hashFile = Utils.getOrCreateHashFile();
        try {
            Scanner fileReader = new Scanner(hashFile);
            if (fileReader.hasNextLine()) {
                String hashFromFile = fileReader.nextLine();
                BeansUtils.LOGGER.info("Custom hash found: {}", (Object)hashFromFile);
                cir.setReturnValue((Object)hashFromFile);
            } else {
                BeansUtils.LOGGER.warn("No hash for custom resource pack.");
            }
            fileReader.close();
        }
        catch (FileNotFoundException e) {
            BeansUtils.LOGGER.error("Could not get hash file: {}", (Object)String.valueOf(e));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/class_2720;comp_2159()Ljava/lang/String;"}, cancellable=true)
    public void getResourceURL(CallbackInfoReturnable<String> cir) {
        if (Utils.isResourcePackUrlOverrideSet()) {
            BeansUtils.LOGGER.info("Custom resource pack found");
            cir.setReturnValue((Object)BeansUtils.SERVER_CONFIG.resourcePackSettings.serverResourcePackURL);
        }
    }
}

