/*
 * Decompiled with CFR 0.152.
 */
package net.ds;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.ds.command.BeansUtilsCommands;
import net.ds.config.ModServerConfig;
import net.ds.events.EndTick;
import net.ds.events.ServerStopping;
import net.ds.network.CombatPayload;
import net.ds.network.HandshakePayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeansUtils
implements ModInitializer {
    public static boolean MOD_ENABLED = true;
    public static final String MOD_ID = "beans-utils";
    public static final String MOD_VERSION = FabricLoader.getInstance().getModContainer("beans-utils").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"beans-utils");
    public static final class_5321<class_8110> COMBAT_LOG_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)BeansUtils.of("combat_log"));
    public static final Map<UUID, Integer> waitingForResponse = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> clientsWithMods = new ConcurrentHashMap<UUID, Boolean>();
    public static MinecraftServer SERVER;
    private static final class_2558 CLICK_EVENT;

    public void onInitialize() {
        BeansUtils.registerPayloads();
        BeansUtils.registerEvents();
        CommandRegistrationCallback.EVENT.register(BeansUtilsCommands::registerCommands);
        LOGGER.info("BeansUtils Common initialized ({})", (Object)MOD_VERSION);
    }

    public static class_2960 of(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static void registerEvents() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerTickEvents.END_SERVER_TICK.register((Object)EndTick.INSTANCE);
            ServerLifecycleEvents.SERVER_STOPPING.register((Object)ServerStopping.INSTANCE);
            ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
                SERVER = minecraftServer;
            });
            ServerPlayerEvents.JOIN.register(HandshakePayload::attemptHandshake);
            ServerPlayerEvents.LEAVE.register(serverPlayerEntity -> {
                waitingForResponse.remove(serverPlayerEntity.method_5667());
                clientsWithMods.remove(serverPlayerEntity.method_5667());
            });
        }
    }

    private static void registerPayloads() {
        PayloadTypeRegistry.playC2S().register(HandshakePayload.HandshakeC2SPayload.ID, HandshakePayload.HandshakeC2SPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(HandshakePayload.HandshakeS2CPayload.ID, HandshakePayload.HandshakeS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CombatPayload.CombatS2CPayload.ID, CombatPayload.CombatS2CPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(HandshakePayload.HandshakeC2SPayload.ID, BeansUtils::playerHandshakeRespond);
    }

    public static void handshakeServerTick(MinecraftServer server) {
        waitingForResponse.replaceAll((uuid, ticks) -> ticks - 1);
        waitingForResponse.entrySet().removeIf(entry -> {
            class_3222 player;
            UUID uuid = (UUID)entry.getKey();
            int ticksLeft = (Integer)entry.getValue();
            if (ticksLeft <= 0 && (player = server.method_3760().method_14602(uuid)) != null) {
                BeansUtils.playerHandshakeTimeout(player);
                return true;
            }
            return false;
        });
    }

    public static void playerHandshakeTimeout(class_3222 player) {
        LOGGER.info("{} failed to respond to handshake", (Object)Objects.requireNonNull(player.method_5476()).getString());
        waitingForResponse.remove(player.method_5667());
        if (ModServerConfig.INSTANCE.getRequireMod()) {
            player.field_13987.method_52396((class_2561)class_2561.method_43470((String)ModServerConfig.INSTANCE.getKickMessage()).method_27694(style -> {
                style.method_10977(class_124.field_1075);
                style.method_10958(CLICK_EVENT);
                return style;
            }));
            return;
        }
        clientsWithMods.put(player.method_5667(), false);
    }

    public static void playerHandshakeRespond(HandshakePayload.HandshakeC2SPayload payload, ServerPlayNetworking.Context context) {
        String receivedVersion = payload.modVersion();
        class_3222 player = context.player();
        waitingForResponse.remove(player.method_5667());
        if (!Objects.equals(receivedVersion, MOD_VERSION)) {
            LOGGER.info("{} has mismatched client version", (Object)Objects.requireNonNull(player.method_5476()).getString());
            String message = "Outdated/Incorrect BeansUtils mod version (Client Version: %s, Server Version: %s)".formatted(receivedVersion, MOD_VERSION);
            player.field_13987.method_52396(class_2561.method_30163((String)message));
        } else {
            LOGGER.info("{} has successfully joined with matching BeansUtils version!!", (Object)Objects.requireNonNull(player.method_5476()).getString());
            clientsWithMods.put(player.method_5667(), true);
        }
    }

    public static boolean doesPlayerHaveMod(UUID uuid) {
        return clientsWithMods.getOrDefault(uuid, false);
    }

    static {
        CLICK_EVENT = new class_2558.class_10608(URI.create("https://github.com/Destruction-Studios/beans-utils"));
    }
}

