/*
 * Decompiled with CFR 0.152.
 */
package net.ds.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.ds.config.ModServerConfig;
import net.ds.tpa.TPACommands;
import net.ds.util.Util;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class BeansUtilsCommands {
    private static final String[] FEATURES = new String[]{"netherPortalsDisabled", "endPortalsDisabled", "eyesOfEnderDisabled"};

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        TPACommands.registerTPACommands(dispatcher, registryAccess, env);
        if (env.field_25423) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"beans-utils").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"reload").executes(BeansUtilsCommands::reloadConfig))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resources").then(class_2170.method_9247((String)"fetchHash").executes(BeansUtilsCommands::fetchHash))).then(class_2170.method_9247((String)"reloadPlayerResourcePacks").executes(BeansUtilsCommands::reloadAll))).then(class_2170.method_9247((String)"setUrl").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(BeansUtilsCommands::setUrl))))).then(class_2170.method_9247((String)"vanillaFeatures").then(class_2170.method_9244((String)"featureName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
                for (String f : FEATURES) {
                    builder.suggest(f);
                }
                return builder.buildFuture();
            }).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(BeansUtilsCommands::setVanillaFeature)))));
        }
    }

    public static void sendFeedback(CommandContext<class_2168> context, String message) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)message), true);
    }

    private static int setVanillaFeature(CommandContext<class_2168> context) {
        String featureName = StringArgumentType.getString(context, (String)"featureName");
        boolean value = BoolArgumentType.getBool(context, (String)"value");
        boolean failed = false;
        switch (featureName) {
            case "netherPortalsDisabled": {
                ModServerConfig.INSTANCE.setNetherPortalsDisabled(value);
                break;
            }
            case "endPortalsDisabled": {
                ModServerConfig.INSTANCE.setEndPortalsDisabled(value);
                break;
            }
            case "eyesOfEnderDisabled": {
                ModServerConfig.INSTANCE.setEyesOfEnderDisabled(value);
                break;
            }
            default: {
                failed = true;
            }
        }
        if (!failed) {
            ModServerConfig.INSTANCE.save();
            BeansUtilsCommands.sendFeedback(context, "Set " + featureName + " = " + value);
            return 1;
        }
        BeansUtilsCommands.sendFeedback(context, "Unknown feature name " + featureName);
        return -1;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        ModServerConfig.INSTANCE.reloadConfigFile();
        BeansUtilsCommands.sendFeedback(context, "Reloaded BeansUtils config!");
        return 1;
    }

    private static int fetchHash(CommandContext<class_2168> context) {
        Util.fetchHash((class_2168)context.getSource());
        return 1;
    }

    private static int setUrl(CommandContext<class_2168> context) {
        String url = StringArgumentType.getString(context, (String)"url");
        ModServerConfig.INSTANCE.setCustomResourcePackURL(url);
        ModServerConfig.INSTANCE.save();
        BeansUtilsCommands.sendFeedback(context, "Successfully set resource pack url.");
        return 1;
    }

    private static int reloadAll(CommandContext<class_2168> context) {
        Util.reloadAll(context);
        BeansUtilsCommands.sendFeedback(context, "Reloaded all players resource packs");
        return 1;
    }
}

