/*
 * Decompiled with CFR 0.152.
 */
package net.ds.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ModClientConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_FILE = Path.of("config", new String[0]).resolve("beans-utils").resolve("client_config_v2.json");
    public static final ModClientConfig DEFAULTS = new ModClientConfig();
    public static ModClientConfig INSTANCE = ModClientConfig.load(CONFIG_FILE.toFile());
    Server server = new Server();
    CombatTagging combatTagging = new CombatTagging();
    Debug debug = new Debug();

    public boolean getDontReloadResources() {
        return this.server.dontReloadResources;
    }

    public void setDontReloadResources(Boolean value) {
        this.server.dontReloadResources = value;
    }

    public boolean getSendServerConnectToast() {
        return this.server.sendConnectToast;
    }

    public void setSendServerConnectToast(Boolean value) {
        this.server.sendConnectToast = value;
    }

    public boolean getPreventLeaving() {
        return this.combatTagging.preventLeavingInCombat;
    }

    public void setPreventLeaving(Boolean value) {
        this.combatTagging.preventLeavingInCombat = value;
    }

    public boolean getIgnoreHandshake() {
        return this.debug.ignoreHandshake;
    }

    public void setIgnoreHandshake(Boolean value) {
        this.debug.ignoreHandshake = value;
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE.toFile());
    }

    private void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving config: " + String.valueOf(e));
        }
    }

    private static ModClientConfig load(File file) {
        ModClientConfig config = null;
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating directories: " + String.valueOf(e));
        }
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (ModClientConfig)GSON.fromJson((Reader)reader, ModClientConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading config: " + String.valueOf(e));
            }
        }
        if (config == null) {
            config = new ModClientConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    static class Server {
        boolean sendConnectToast = true;
        boolean dontReloadResources = false;

        Server() {
        }
    }

    static class CombatTagging {
        boolean preventLeavingInCombat = false;

        CombatTagging() {
        }
    }

    static class Debug {
        boolean ignoreHandshake = false;

        Debug() {
        }
    }
}

