/*
 * Decompiled with CFR 0.152.
 */
package net.ds.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class ModServerConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_FILE = Path.of("config", new String[0]).resolve("beans-utils").resolve("server_config_v2.json");
    public static final ModServerConfig DEFAULTS = new ModServerConfig();
    public static ModServerConfig INSTANCE = ModServerConfig.load(CONFIG_FILE.toFile());
    ModSettings modSettings = new ModSettings();
    Server server = new Server();
    VanillaFeatures vanillaFeaturesToggling = new VanillaFeatures();
    CombatTagging combatTagging = new CombatTagging();
    TPA tpa = new TPA();

    public boolean getRequireMod() {
        return this.modSettings.requireMod;
    }

    public void setRequireMod(boolean value) {
        this.modSettings.requireMod = value;
    }

    public String getKickMessage() {
        return this.modSettings.kickMessage;
    }

    public void setKickMessage(String value) {
        this.modSettings.kickMessage = value;
    }

    public int getHandshakeTimeout() {
        return this.modSettings.handshakeTimeout * 20;
    }

    public void setHandshakeTimeout(int value) {
        this.modSettings.handshakeTimeout = value;
    }

    public boolean getPvpEnabled() {
        return this.server.pvpEnabled;
    }

    public void setPvpEnabled(boolean value) {
        this.server.pvpEnabled = value;
    }

    public boolean getUseCustomResourcePack() {
        return this.server.resourcePackSettings.useCustomResourcePack;
    }

    public void setUseCustomResourcePack(boolean value) {
        this.server.resourcePackSettings.useCustomResourcePack = value;
    }

    public String getCustomResourcePackURL() {
        return this.server.resourcePackSettings.customResourcePackURL;
    }

    public void setCustomResourcePackURL(String value) {
        this.server.resourcePackSettings.customResourcePackURL = value;
    }

    public String getCustomHash() {
        return this.server.resourcePackSettings.customHash;
    }

    public void setCustomHash(String value) {
        this.server.resourcePackSettings.customHash = value;
    }

    public boolean getNetherPortalsDisabled() {
        return this.vanillaFeaturesToggling.netherPortalsDisabled;
    }

    public void setNetherPortalsDisabled(boolean value) {
        this.vanillaFeaturesToggling.netherPortalsDisabled = value;
    }

    public boolean getEndPortalsDisabled() {
        return this.vanillaFeaturesToggling.endPortalsDisabled;
    }

    public void setEndPortalsDisabled(boolean value) {
        this.vanillaFeaturesToggling.endPortalsDisabled = value;
    }

    public boolean getEyesOfEnderDisabled() {
        return this.vanillaFeaturesToggling.eyesOfEnderDisabled;
    }

    public void setEyesOfEnderDisabled(boolean value) {
        this.vanillaFeaturesToggling.eyesOfEnderDisabled = value;
    }

    public boolean getCombatTaggingEnabled() {
        return this.combatTagging.combatTaggingEnabled;
    }

    public void setCombatTaggingEnabled(boolean value) {
        this.combatTagging.combatTaggingEnabled = value;
    }

    public int getCombatDuration() {
        return this.combatTagging.combatDuration;
    }

    public void setCombatDuration(int value) {
        this.combatTagging.combatDuration = value;
    }

    public boolean getKillPlayerUponCombatLogging() {
        return this.combatTagging.killPlayerUponCombatLogging;
    }

    public void setKillPlayerUponCombatLogging(boolean value) {
        this.combatTagging.killPlayerUponCombatLogging = value;
    }

    public List<String> getCombatTriggeringEntities() {
        return this.combatTagging.combatTriggeringEntities;
    }

    public void setCombatTriggeringEntities(List<String> value) {
        this.combatTagging.combatTriggeringEntities = value;
    }

    public boolean getDisabledEnderPearls() {
        return this.combatTagging.combatDisabledFeatures.disabledEnderPearls;
    }

    public void setDisabledEnderPearls(boolean value) {
        this.combatTagging.combatDisabledFeatures.disabledEnderPearls = value;
    }

    public boolean getDisableFireworkRockets() {
        return this.combatTagging.combatDisabledFeatures.disableFireworkRockets;
    }

    public void setDisableFireworkRockets(boolean value) {
        this.combatTagging.combatDisabledFeatures.disableFireworkRockets = value;
    }

    public boolean getDisableTridents() {
        return this.combatTagging.combatDisabledFeatures.disableTridents;
    }

    public void setDisableTridents(boolean value) {
        this.combatTagging.combatDisabledFeatures.disableTridents = value;
    }

    public boolean getTpaEnabled() {
        return this.tpa.tpaEnabled;
    }

    public void setTpaEnabled(boolean v) {
        this.tpa.tpaEnabled = v;
    }

    public int getTpaTimeout() {
        return this.tpa.tpaTimeout * 20;
    }

    public void setTpaTimeout(int v) {
        this.tpa.tpaTimeout = v;
    }

    public int getTpaExpRequirement() {
        return this.tpa.tpaExpRequirement;
    }

    public void setTpaExpRequirement(int v) {
        this.tpa.tpaExpRequirement = v;
    }

    public void reloadConfigFile() {
        INSTANCE = ModServerConfig.load(CONFIG_FILE.toFile());
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE.toFile());
    }

    private void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving config: " + String.valueOf(e));
        }
    }

    private static ModServerConfig load(File file) {
        ModServerConfig config = null;
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating directories: " + String.valueOf(e));
        }
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (ModServerConfig)GSON.fromJson((Reader)reader, ModServerConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading config: " + String.valueOf(e));
            }
        }
        if (config == null) {
            config = new ModServerConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    static class ModSettings {
        boolean requireMod = false;
        String kickMessage = "This server requires BeansUtils.";
        int handshakeTimeout = 3;

        ModSettings() {
        }
    }

    static class Server {
        boolean pvpEnabled = true;
        ResourcePackSettings resourcePackSettings = new ResourcePackSettings();

        Server() {
        }

        static class ResourcePackSettings {
            boolean useCustomResourcePack = false;
            String customResourcePackURL = "";
            String customHash = "";

            ResourcePackSettings() {
            }
        }
    }

    static class VanillaFeatures {
        boolean netherPortalsDisabled = false;
        boolean endPortalsDisabled = false;
        boolean eyesOfEnderDisabled = false;

        VanillaFeatures() {
        }
    }

    static class CombatTagging {
        boolean combatTaggingEnabled = false;
        int combatDuration = 15;
        boolean killPlayerUponCombatLogging = true;
        List<String> combatTriggeringEntities = List.of("minecraft:player");
        CombatDisabledFeatures combatDisabledFeatures = new CombatDisabledFeatures();

        CombatTagging() {
        }

        static class CombatDisabledFeatures {
            boolean disabledEnderPearls = false;
            boolean disableFireworkRockets = false;
            boolean disableTridents = false;

            CombatDisabledFeatures() {
            }
        }
    }

    static class TPA {
        boolean tpaEnabled = false;
        int tpaTimeout = 10;
        int tpaExpRequirement = 2;

        TPA() {
        }
    }
}

