/*
 * Decompiled with CFR 0.152.
 */
package net.ds.tpa;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import net.ds.command.PlayerTPASuggestionProvider;
import net.ds.config.ModServerConfig;
import net.ds.tpa.TPAManager;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5454;
import net.minecraft.class_7157;

public class TPACommands {
    public static void registerTPACommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        if (!ModServerConfig.INSTANCE.getTpaEnabled()) {
            return;
        }
        TPA.register(dispatcher);
        TPAHere.register(dispatcher);
        TPAccept.register(dispatcher);
        TPACancel.register(dispatcher);
    }

    private static void sendFeedback(CommandContext<class_2168> context, class_2561 text) {
        ((class_2168)context.getSource()).method_9226(() -> text, false);
    }

    private static void sendSound(class_3222 player, class_3414 soundEvent) {
        player.method_17356(soundEvent, class_3419.field_15250, 1.0f, 1.0f);
    }

    public static class TPA {
        private static final String COMMAND = "tpa";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(TPA::execute)));
        }

        private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 1;
            }
            class_3222 player = Objects.requireNonNull(((class_2168)context.getSource()).method_44023());
            class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
            UUID playerUUID = player.method_5667();
            String playerName = ((class_2168)context.getSource()).method_44023().method_5477().getString();
            UUID targetUUID = targetPlayer.method_5667();
            String targetName = targetPlayer.method_5477().getString();
            if (playerUUID == targetUUID) {
                TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"You can not teleport to yourself.").method_27692(class_124.field_1061));
                return 1;
            }
            if (TPAManager.playerTPAHereMap.containsKey(targetUUID) && TPAManager.playerTPAHereMap.get(playerUUID).contains(playerUUID)) {
                TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"You have already requested this player to TPAHere to you.").method_27692(class_124.field_1061));
                return 1;
            }
            if (TPAManager.playerTPAMap.containsKey(targetUUID)) {
                if (TPAManager.playerTPAMap.get(playerUUID).contains(playerUUID)) {
                    TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"You have already requested to TPA to this player.").method_27692(class_124.field_1061));
                    return 1;
                }
                TPAManager.playerTPAMap.get(targetUUID).add(playerUUID);
            } else {
                ArrayList<UUID> uuidList = new ArrayList<UUID>();
                uuidList.add(playerUUID);
                TPAManager.playerTPAMap.put(targetUUID, uuidList);
            }
            targetPlayer.method_64398((class_2561)class_2561.method_43470((String)String.format("%s wants to teleport to you! Accept with /tpaccept or click here!", playerName)).method_27692(class_124.field_1065).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/tpaccept " + playerName))));
            TPACommands.sendSound(player, class_3417.field_43154);
            TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"TPA request send!").method_54663(-16711936));
            TPAManager.addRunnable(() -> {
                if (TPAManager.playerTPAMap.containsKey(targetUUID) && TPAManager.playerTPAMap.get(targetUUID).contains(playerUUID)) {
                    TPAManager.playerTPAMap.get(targetUUID).remove(playerUUID);
                    if (TPAManager.playerTPAMap.get(targetUUID).isEmpty()) {
                        TPAManager.playerTPAMap.remove(targetUUID);
                    }
                    TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Your TPA request has expired.").method_27692(class_124.field_1061));
                    TPACommands.sendSound(player, class_3417.field_15008);
                }
            });
            return 1;
        }
    }

    public static class TPAHere {
        private static final String COMMAND = "tpahere";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(TPAHere::execute)));
        }

        private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 1;
            }
            class_3222 player = Objects.requireNonNull(((class_2168)context.getSource()).method_44023());
            class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
            UUID playerUUID = player.method_5667();
            String playerName = ((class_2168)context.getSource()).method_44023().method_5477().getString();
            UUID targetUUID = targetPlayer.method_5667();
            String targetName = targetPlayer.method_5477().getString();
            if (playerUUID == targetUUID) {
                TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"You can not teleport to yourself.").method_27692(class_124.field_1061));
                return 1;
            }
            if (TPAManager.playerTPAMap.containsKey(targetUUID) && TPAManager.playerTPAMap.get(targetUUID).contains(playerUUID)) {
                TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"You have already requested this player to TPA to you.").method_27692(class_124.field_1061));
                return 1;
            }
            if (TPAManager.playerTPAHereMap.containsKey(targetUUID)) {
                if (TPAManager.playerTPAHereMap.get(targetUUID).contains(playerUUID)) {
                    TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"You have already requested this player to TPAHere to you.").method_27692(class_124.field_1061));
                    return 1;
                }
                TPAManager.playerTPAHereMap.get(targetUUID).add(playerUUID);
            } else {
                ArrayList<UUID> uuidList = new ArrayList<UUID>();
                uuidList.add(playerUUID);
                TPAManager.playerTPAHereMap.put(targetUUID, uuidList);
            }
            targetPlayer.method_64398((class_2561)class_2561.method_43470((String)String.format("%s wants you to teleport to him! Accept with /tpaccept or click here!", playerName)).method_27692(class_124.field_1065).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/tpaccept " + playerName))));
            TPACommands.sendSound(targetPlayer, class_3417.field_43154);
            TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"TPAHere request sent!").method_27692(class_124.field_1060));
            TPAManager.addRunnable(() -> {
                if (TPAManager.playerTPAHereMap.containsKey(targetUUID) && TPAManager.playerTPAHereMap.get(targetUUID).contains(playerUUID)) {
                    TPAManager.playerTPAHereMap.get(targetUUID).remove(playerUUID);
                    if (TPAManager.playerTPAHereMap.get(targetUUID).isEmpty()) {
                        TPAManager.playerTPAHereMap.remove(targetUUID);
                    }
                    TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Your TPAHere request has expired.").method_27692(class_124.field_1061));
                    TPACommands.sendSound(player, class_3417.field_15008);
                }
            });
            return 1;
        }
    }

    public static class TPAccept {
        private static final String COMMAND = "tpaccept";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).suggests((SuggestionProvider)new PlayerTPASuggestionProvider()).executes(TPAccept::execute)));
        }

        private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 1;
            }
            class_3222 player = Objects.requireNonNull(((class_2168)context.getSource()).method_44023());
            UUID playerUUID = class_2186.method_9315(context, (String)"player").method_5667();
            if (TPAManager.playerTPAMap.containsKey(player.method_5667())) {
                if (!TPAManager.playerTPAMap.get(player.method_5667()).contains(playerUUID)) {
                    TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"There is no TPA to accept.").method_27692(class_124.field_1061));
                    return 1;
                }
                UUID targetUUID = TPAManager.playerTPAMap.get(player.method_5667()).remove(TPAManager.playerTPAMap.get(player.method_5667()).indexOf(playerUUID));
                class_3222 targetPlayer = Objects.requireNonNull(((class_2168)context.getSource()).method_9211().method_3760().method_14602(targetUUID));
                class_5454 teleportTarget = new class_5454(player.method_51469(), player.method_24515().method_46558(), targetPlayer.method_18798(), targetPlayer.method_36454(), targetPlayer.method_36455(), class_5454.field_52247);
                targetPlayer.method_61275(teleportTarget);
                if (TPAManager.playerTPAMap.get(player.method_5667()).isEmpty()) {
                    TPAManager.playerTPAMap.remove(player.method_5667());
                }
                targetPlayer.method_64398((class_2561)class_2561.method_43470((String)"Teleport Success!!").method_27692(class_124.field_1060));
                TPACommands.sendSound(targetPlayer, class_3417.field_15210);
            } else if (TPAManager.playerTPAHereMap.containsKey(player.method_5667())) {
                if (!TPAManager.playerTPAHereMap.get(player.method_5667()).contains(playerUUID)) {
                    TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"There is no TPA to accept").method_27692(class_124.field_1061));
                    return 1;
                }
                UUID targetUuid = TPAManager.playerTPAHereMap.get(player.method_5667()).remove(TPAManager.playerTPAHereMap.get(player.method_5667()).indexOf(playerUUID));
                class_3222 target_player = Objects.requireNonNull(((class_2168)context.getSource()).method_9211().method_3760().method_14602(targetUuid));
                class_5454 teleport_target = new class_5454(target_player.method_51469(), target_player.method_24515().method_46558(), player.method_18798(), player.method_36454(), player.method_36455(), class_5454.field_52247);
                player.method_61275(teleport_target);
                if (TPAManager.playerTPAHereMap.get(player.method_5667()).isEmpty()) {
                    TPAManager.playerTPAHereMap.remove(player.method_5667());
                }
                player.method_64398((class_2561)class_2561.method_43470((String)"Teleport Success!!").method_27692(class_124.field_1060));
                TPACommands.sendSound(player, class_3417.field_15210);
            } else {
                TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"No TPA to accept.").method_27692(class_124.field_1061));
            }
            return 1;
        }
    }

    public static class TPACancel {
        private static final String COMMAND = "tpacancel";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND).executes(TPACancel::execute));
        }

        private static int execute(CommandContext<class_2168> context) {
            UUID playerUUID = Objects.requireNonNull(((class_2168)context.getSource()).method_44023()).method_5667();
            ArrayList<UUID> keysTPA = Collections.list(TPAManager.playerTPAMap.keys());
            ArrayList<UUID> keysTPAHere = Collections.list(TPAManager.playerTPAHereMap.keys());
            for (UUID targetUUID : keysTPA) {
                TPAManager.playerTPAMap.get(targetUUID).remove(playerUUID);
                if (!TPAManager.playerTPAMap.get(targetUUID).isEmpty()) continue;
                TPAManager.playerTPAMap.remove(targetUUID);
            }
            for (UUID targetUUID : keysTPAHere) {
                TPAManager.playerTPAHereMap.get(targetUUID).remove(playerUUID);
                if (!TPAManager.playerTPAHereMap.get(targetUUID).isEmpty()) continue;
                TPAManager.playerTPAHereMap.remove(targetUUID);
            }
            TPACommands.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Cancalled all TPA requests!").method_27692(class_124.field_1054));
            return 1;
        }
    }
}

