/*
 * Decompiled with CFR 0.152.
 */
package net.ds.util;

import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.ds.BeansUtils;
import net.ds.config.ModServerConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.codec.digest.DigestUtils;

public class Util {
    public static String tickToString(int tick) {
        return String.format("%.1f", Float.valueOf((float)tick / 20.0f));
    }

    public static boolean isResourcePackUrlOverrideSet() {
        return ModServerConfig.INSTANCE.getUseCustomResourcePack() && !Objects.equals(ModServerConfig.INSTANCE.getCustomResourcePackURL(), "");
    }

    public static String getSha1FromFile(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            String sha1 = DigestUtils.sha1Hex((InputStream)fis);
            fis.close();
            return sha1;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void fetchHash(class_2168 source) {
        try {
            if (Objects.equals(ModServerConfig.INSTANCE.getCustomResourcePackURL(), "")) {
                BeansUtils.LOGGER.warn("No custom url set");
                source.method_45068((class_2561)class_2561.method_43470((String)"No custom url set").method_54663(-65536));
                return;
            }
            String url = ModServerConfig.INSTANCE.getCustomResourcePackURL();
            source.method_45068((class_2561)class_2561.method_43470((String)("Downloading: " + url)).method_54663(-16776961));
            BufferedInputStream inputStream = new BufferedInputStream(new URL(url).openStream());
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            DigestInputStream digestInputStream = new DigestInputStream(inputStream, digest);
            while (digestInputStream.read() != -1) {
            }
            digestInputStream.close();
            BeansUtils.LOGGER.info("Resource pack downloaded, calculating hash");
            byte[] hash = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                hexString.append(String.format("%02x", b));
            }
            String hashFinal = hexString.toString().toLowerCase(Locale.ROOT);
            ModServerConfig.INSTANCE.setCustomHash(hashFinal);
            ModServerConfig.INSTANCE.save();
            BeansUtils.LOGGER.info("Got hash: {}", (Object)hashFinal);
            source.method_45068((class_2561)class_2561.method_43470((String)("Successfully fetched hash: " + hashFinal)).method_54663(-16711936));
        }
        catch (NoSuchElementException e) {
            BeansUtils.LOGGER.error("Could not get resource pack url: {}", (Object)String.valueOf(e));
        }
        catch (MalformedURLException e) {
            BeansUtils.LOGGER.error("Invalid resource pack url: {}", (Object)String.valueOf(e));
        }
        catch (IOException e) {
            BeansUtils.LOGGER.error("IOException: {}", (Object)String.valueOf(e));
        }
        catch (NoSuchAlgorithmException e) {
            BeansUtils.LOGGER.error("Invalid alg: {}", (Object)String.valueOf(e));
        }
    }

    public static void reloadAll(CommandContext<class_2168> context) {
        Optional props = ((class_2168)context.getSource()).method_9211().method_43659();
        if (props.isPresent()) {
            String url = ((MinecraftServer.class_7460)props.get()).comp_784();
            if (Util.isResourcePackUrlOverrideSet()) {
                url = ModServerConfig.INSTANCE.getCustomResourcePackURL();
            }
            class_2561 prompt = class_2561.method_30163((String)"New Resource Pack People!!");
            for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                player.field_13987.method_14364((class_2596)new class_2720(((MinecraftServer.class_7460)props.get()).comp_2156(), url, ((MinecraftServer.class_7460)props.get()).comp_785(), true, Optional.of(prompt)));
            }
        }
    }
}

