/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block;

import alabaster.crabbersdelight.common.registry.CDDamageSources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoconutBlock
extends FallingBlock {
    public static final BooleanProperty HANGING = BooleanProperty.m_61465_((String)"hanging");
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public CoconutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HANGING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
            return Block.m_49796_((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
        }
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (facing == Direction.UP) {
            boolean hanging;
            boolean bl = hanging = !neighborState.m_60795_();
            if (!hanging) {
                level.m_186460_(pos, (Block)this, 1);
            }
            return (BlockState)state.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
        }
        return super.m_7417_(state, facing, neighborState, level, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos above;
        Level level = context.m_43725_();
        BlockState aboveState = level.m_8055_(above = context.m_8083_().m_7494_());
        boolean hanging = !aboveState.m_60795_();
        return (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
            super.m_213897_(state, level, pos, random);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state, BlockState replaceState, FallingBlockEntity fallingEntity) {
        super.m_48792_(level, pos, state, replaceState, fallingEntity);
        if (!level.f_46443_ && fallingEntity != null) {
            boolean hitPlayer = false;
            for (Entity entity : level.m_45933_(null, SHAPE.m_83215_().m_82338_(pos))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                living.m_6469_(CDDamageSources.getSimpleDamageSource(level, CDDamageSources.FALLING_COCONUT), 2.0f);
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215698_, SoundSource.PLAYERS, 0.7f, 0.5f);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2));
                hitPlayer = true;
            }
            if (hitPlayer) {
                level.m_46961_(pos, true);
            }
        }
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        super.m_5581_(level, state, hit, projectile);
        if (!level.f_46443_) {
            BlockPos pos = hit.m_82425_();
            if (((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)), 3);
                level.m_186460_(pos, (Block)this, 1);
            }
        }
    }
}

