/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.data;

import alabaster.crabbersdelight.common.registry.CDModBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class BlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockStates(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "crabbersdelight", existingFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("crabbersdelight", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.barrelBlock(CDModBlocks.CRAB_BARREL.get(), "crab");
        this.barrelBlock(CDModBlocks.CLAM_BARREL.get(), "clam");
        this.barrelBlock(CDModBlocks.CLAWSTER_BARREL.get(), "clawster");
        this.barrelBlock(CDModBlocks.SHRIMP_BARREL.get(), "shrimp");
        this.barrelBlock(CDModBlocks.COD_BARREL.get(), "cod");
        this.barrelBlock(CDModBlocks.SALMON_BARREL.get(), "salmon");
        this.barrelBlock(CDModBlocks.PUFFERFISH_BARREL.get(), "pufferfish");
        this.barrelBlock(CDModBlocks.TROPICAL_FISH_BARREL.get(), "tropical_fish");
        this.barrelBlock(CDModBlocks.SQUID_BARREL.get(), "squid");
        this.barrelBlock(CDModBlocks.GLOW_SQUID_BARREL.get(), "glow_squid");
        this.barrelBlock(CDModBlocks.FROG_LEG_BARREL.get(), "frog_leg");
        this.logBlock((RotatedPillarBlock)CDModBlocks.PALM_LOG.get());
        this.axisBlock((RotatedPillarBlock)CDModBlocks.PALM_WOOD.get(), this.blockTexture(CDModBlocks.PALM_LOG.get()), this.blockTexture(CDModBlocks.PALM_LOG.get()));
        this.logBlock((RotatedPillarBlock)CDModBlocks.STRIPPED_PALM_LOG.get());
        this.axisBlock((RotatedPillarBlock)CDModBlocks.STRIPPED_PALM_WOOD.get(), this.blockTexture(CDModBlocks.STRIPPED_PALM_LOG.get()), this.blockTexture(CDModBlocks.STRIPPED_PALM_LOG.get()));
        this.simpleBlockWithItem(CDModBlocks.PALM_PLANKS.get(), (ModelFile)this.models().cubeAll("palm_planks", this.blockTexture(CDModBlocks.PALM_PLANKS.get())));
        this.stairsBlock(CDModBlocks.PALM_STAIRS.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.slabBlock(CDModBlocks.PALM_SLAB.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.fenceBlock(CDModBlocks.PALM_FENCE.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.fenceGateBlock(CDModBlocks.PALM_FENCE_GATE.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.doorBlockWithRenderType(CDModBlocks.PALM_DOOR.get(), this.modLoc("block/palm_door_bottom"), this.modLoc("block/palm_door_top"), "cutout");
        this.trapdoorBlockWithRenderType(CDModBlocks.PALM_TRAPDOOR.get(), this.modLoc("block/palm_trapdoor"), true, "cutout");
        this.signBlock(CDModBlocks.PALM_SIGN.get(), CDModBlocks.PALM_WALL_SIGN.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.hangingSignBlock((Block)CDModBlocks.PALM_HANGING_SIGN.get(), (Block)CDModBlocks.PALM_WALL_HANGING_SIGN.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.pressurePlateBlock(CDModBlocks.PALM_PRESSURE_PLATE.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.buttonBlock(CDModBlocks.PALM_BUTTON.get(), this.blockTexture(CDModBlocks.PALM_PLANKS.get()));
        this.leavesBlock(CDModBlocks.PALM_LEAVES.get());
        this.saplingBlock(CDModBlocks.PALM_SAPLING.get());
        this.cabinetBlock(CDModBlocks.PALM_CABINET.get(), "palm");
    }

    public void barrelBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock("barrel_side"), this.resourceBlock("barrel_bottom"), this.resourceBlock(cropName + "_barrel_top")));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private void leavesBlock(Block block) {
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_(), this.mcLoc("block/leaves"), "all", this.blockTexture(block))).renderType("cutout"));
    }

    private void saplingBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_(), this.blockTexture(block))).renderType("cutout"));
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName(block) + suffix, this.resourceBlock(woodType + "_cabinet_side"), this.resourceBlock(woodType + "_cabinet_front" + suffix), this.resourceBlock(woodType + "_cabinet_top"));
        });
    }
}

