/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block;

import alabaster.crabbersdelight.common.Config;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeashellBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)63);
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);

    public SeashellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VARIANT, FACING, WATERLOGGED});
    }

    private int getVariantCount() {
        return (Integer)Config.SEASHELL_VARIANT_COUNT.get();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        int count = this.getVariantCount();
        int variant = context.m_43725_().m_213780_().m_188503_(count);
        Direction facing = Direction.Plane.HORIZONTAL.m_235690_(context.m_43725_().m_213780_());
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(variant))).m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        Vec3 offset = state.m_60824_(world, pos);
        return SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState ground = level.m_8055_(below);
        return ground.m_60783_((BlockGetter)level, below, Direction.UP);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        } else if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return super.m_7417_(state, dir, neighborState, level, pos, neighborPos);
    }
}

