/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen.tree;

import alabaster.crabbersdelight.common.block.CDLeavesBlock;
import alabaster.crabbersdelight.common.block.CoconutBlock;
import alabaster.crabbersdelight.common.registry.CDFoliagePlacerTypes;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class PalmFoliagePlacer
extends FoliagePlacer {
    public static final Codec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> PalmFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PalmFoliagePlacer::new));

    public PalmFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> m_5897_() {
        return CDFoliagePlacerTypes.PALM_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos center = attachment.m_161451_();
        BlockPos tuftCenter = attachment.m_161451_().m_6630_(0);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.m_122012_());
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.m_122019_());
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.m_122029_());
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.m_122024_());
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 1, 0);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, -1, 0);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 0, 1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 0, -1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 1, 1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 1, -1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, -1, 1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, -1, -1);
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return 0;
    }

    protected boolean m_214203_(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }

    private static void createFrond(BlockPos start, LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int dx, int dz) {
        BlockPos.MutableBlockPos pos = start.m_122032_();
        pos.m_122178_(start.m_123341_() + dx, start.m_123342_() - 1, start.m_123343_() + dz);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, (BlockPos)pos);
        for (int i = 2; i <= 3; ++i) {
            pos.m_122178_(start.m_123341_() + dx * i, start.m_123342_() - 1, start.m_123343_() + dz * i);
            PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, (BlockPos)pos);
        }
        pos.m_122178_(start.m_123341_() + dx * 4, start.m_123342_() - 2, start.m_123343_() + dz * 4);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, (BlockPos)pos);
    }

    private static void placeLeafWithCoconut(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        BlockPos below;
        BlockState leaf = config.f_161213_.m_213972_(random, pos);
        if (leaf.m_61138_((Property)CDLeavesBlock.GENERATED)) {
            leaf = (BlockState)leaf.m_61124_((Property)CDLeavesBlock.GENERATED, (Comparable)Boolean.valueOf(true));
        }
        setter.m_271838_(pos, leaf);
        if (random.m_188503_(5) == 0 && level.m_7433_(below = pos.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) {
            setter.m_271838_(below, (BlockState)CDModBlocks.COCONUT.get().m_49966_().m_61124_((Property)CoconutBlock.HANGING, (Comparable)Boolean.valueOf(true)));
        }
    }
}

