/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen.tree;

import alabaster.crabbersdelight.common.block.CoconutBlock;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.registry.CDTrunkPlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class PalmTrunkPlacer
extends TrunkPlacer {
    public static final Codec<PalmTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> PalmTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and((App)IntProvider.f_146531_.fieldOf("bend_length").forGetter(p -> p.bendLength)).apply((Applicative)instance, PalmTrunkPlacer::new));
    private final IntProvider bendLength;

    public PalmTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider bendLength) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.bendLength = bendLength;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return CDTrunkPlacerTypes.PALM.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        int dx = random.m_188499_() ? 1 : -1;
        int dz = random.m_188499_() ? 1 : -1;
        int bend = this.bendLength.m_214085_(random);
        BlockPos.MutableBlockPos cursor = pos.m_122032_();
        for (int y = 0; y < height; ++y) {
            if (y > height / 3 && bend > 0 && random.m_188503_(3) == 0) {
                cursor.m_122184_(dx, 0, dz);
                --bend;
            }
            this.m_226187_(level, blockSetter, random, (BlockPos)cursor, config);
            cursor.m_122184_(0, 1, 0);
        }
        int CHANCE = 20;
        int RADIUS = 3;
        int MAX_COCONUTS = 3;
        int MAX_ATTEMPTS = 10;
        int MAX_DESCEND = 6;
        if (random.m_188503_(20) == 0) {
            int coconutCount = 1 + random.m_188503_(3);
            block1: for (int i = 0; i < coconutCount; ++i) {
                for (int attempt = 0; attempt < 10; ++attempt) {
                    int rx = pos.m_123341_() + random.m_188503_(7) - 3;
                    int rz = pos.m_123343_() + random.m_188503_(7) - 3;
                    BlockPos candidate = new BlockPos(rx, pos.m_123342_(), rz);
                    boolean placed = false;
                    for (int dy = 0; dy >= -6; --dy) {
                        BlockPos target = candidate.m_7918_(0, dy, 0);
                        if (!level.m_7433_(target, BlockBehaviour.BlockStateBase::m_60795_) || level.m_7433_(target.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) continue;
                        blockSetter.accept(target, (BlockState)CDModBlocks.COCONUT.get().m_49966_().m_61124_((Property)CoconutBlock.HANGING, (Comparable)Boolean.valueOf(false)));
                        placed = true;
                        break;
                    }
                    if (placed) continue block1;
                }
            }
        }
        return List.of(new FoliagePlacer.FoliageAttachment((BlockPos)cursor, 0, false));
    }
}

