/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity.boat;

import alabaster.crabbersdelight.common.entity.boat.CDBoatEntity;
import alabaster.crabbersdelight.common.entity.boat.CDChestBoatEntity;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class CDBoatRenderer
extends BoatRenderer {
    private final Map<CDBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(CDBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)CDBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (CDBoatEntity.Type)((Object)type), pChestBoat))));

    public CDBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(CDBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, CDBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? CDBoatRenderer.createChestBoatModelName(pType) : CDBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.bakeLayer(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(CDBoatEntity.Type pType) {
        return CDBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(CDBoatEntity.Type pType) {
        return CDBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)pPath), pModel);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof CDBoatEntity) {
            CDBoatEntity modBoat = (CDBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof CDChestBoatEntity) {
            CDChestBoatEntity modChestBoatEntity = (CDChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        return null;
    }
}

