/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity.crab;

import alabaster.crabbersdelight.common.entity.crab.CrabEntity;
import alabaster.crabbersdelight.common.entity.crab.CrabModel;
import alabaster.crabbersdelight.common.entity.crab.CrabVariant;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CrabRenderer
extends MobRenderer<CrabEntity, CrabModel<CrabEntity>> {
    private static final Map<CrabVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CrabVariant.class), map -> {
        map.put(CrabVariant.BLACK, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/black_crab.png"));
        map.put(CrabVariant.BLUE, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/blue_crab.png"));
        map.put(CrabVariant.BROWN, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/brown_crab.png"));
        map.put(CrabVariant.CYAN, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/cyan_crab.png"));
        map.put(CrabVariant.GRAY, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/gray_crab.png"));
        map.put(CrabVariant.GREEN, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/green_crab.png"));
        map.put(CrabVariant.LIGHT_BLUE, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/light_blue_crab.png"));
        map.put(CrabVariant.LIGHT_GRAY, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/light_gray_crab.png"));
        map.put(CrabVariant.LIME, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/lime_crab.png"));
        map.put(CrabVariant.MAGENTA, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/magenta_crab.png"));
        map.put(CrabVariant.ORANGE, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/orange_crab.png"));
        map.put(CrabVariant.PINK, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/pink_crab.png"));
        map.put(CrabVariant.PURPLE, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/purple_crab.png"));
        map.put(CrabVariant.RED, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/red_crab.png"));
        map.put(CrabVariant.WHITE, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/white_crab.png"));
        map.put(CrabVariant.YELLOW, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"textures/entity/yellow_crab.png"));
    });

    public CrabRenderer(EntityRendererProvider.Context context) {
        super(context, new CrabModel(context.bakeLayer(CrabModel.LAYER_LOCATION)), 0.3f);
    }

    public ResourceLocation getTextureLocation(CrabEntity entity) {
        return LOCATION_BY_VARIANT.get((Object)entity.getVariant());
    }

    public void render(CrabEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

