/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen;

import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.worldgen.RandomSeashellStateProvider;
import alabaster.crabbersdelight.common.worldgen.tree.PalmFoliagePlacer;
import alabaster.crabbersdelight.common.worldgen.tree.PalmTrunkPlacer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class CDConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALM_KEY = CDConfiguredFeatures.registerKey("palm");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEASHELLS_KEY = CDConfiguredFeatures.registerKey("seashells_beach");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEASHELLS_KEY_UNDERWATER = CDConfiguredFeatures.registerKey("seashells_underwater");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        CDConfiguredFeatures.register(context, PALM_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)CDModBlocks.PALM_LOG.get()), (TrunkPlacer)new PalmTrunkPlacer(5, 3, 3, (IntProvider)ConstantInt.of((int)3)), (BlockStateProvider)BlockStateProvider.simple((Block)CDModBlocks.PALM_LEAVES.get()), (FoliagePlacer)new PalmFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)3)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).dirt((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SAND)).build());
        BlockPredicate beachPlacement = BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)BlockPos.ZERO.below(), (Block[])new Block[]{Blocks.SAND}), (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)BlockPos.ZERO, List.of(Blocks.AIR)));
        RandomSeashellStateProvider beachProvider = new RandomSeashellStateProvider(false);
        RandomPatchConfiguration beachPatch = new RandomPatchConfiguration(10, 4, 1, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)beachProvider), (BlockPredicate)beachPlacement));
        CDConfiguredFeatures.register(context, SEASHELLS_KEY, Feature.RANDOM_PATCH, beachPatch);
        BlockPredicate underwaterPlacement = BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)BlockPos.ZERO.below(), (Block[])new Block[]{Blocks.SAND}), (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)BlockPos.ZERO, List.of(Blocks.WATER)));
        RandomSeashellStateProvider underwaterProvider = new RandomSeashellStateProvider(true);
        RandomPatchConfiguration underwaterPatch = new RandomPatchConfiguration(10, 4, 1, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)underwaterProvider), (BlockPredicate)underwaterPlacement));
        CDConfiguredFeatures.register(context, SEASHELLS_KEY_UNDERWATER, Feature.RANDOM_PATCH, underwaterPatch);
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

