/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen.tree;

import alabaster.crabbersdelight.common.block.CDLeavesBlock;
import alabaster.crabbersdelight.common.block.CoconutBlock;
import alabaster.crabbersdelight.common.registry.CDFoliagePlacerTypes;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class PalmFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> PalmFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PalmFoliagePlacer::new));

    public PalmFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return CDFoliagePlacerTypes.PALM_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos center = attachment.pos();
        BlockPos tuftCenter = attachment.pos().above(0);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.north());
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.south());
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.east());
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, tuftCenter.west());
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 1, 0);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, -1, 0);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 0, 1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 0, -1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 1, 1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, 1, -1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, -1, 1);
        PalmFoliagePlacer.createFrond(center, level, setter, random, config, -1, -1);
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }

    private static void createFrond(BlockPos start, LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int dx, int dz) {
        BlockPos.MutableBlockPos pos = start.mutable();
        pos.set(start.getX() + dx, start.getY() - 1, start.getZ() + dz);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, (BlockPos)pos);
        for (int i = 2; i <= 3; ++i) {
            pos.set(start.getX() + dx * i, start.getY() - 1, start.getZ() + dz * i);
            PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, (BlockPos)pos);
        }
        pos.set(start.getX() + dx * 4, start.getY() - 2, start.getZ() + dz * 4);
        PalmFoliagePlacer.placeLeafWithCoconut(level, setter, random, config, (BlockPos)pos);
    }

    private static void placeLeafWithCoconut(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        BlockPos below;
        BlockState leaf = config.foliageProvider.getState(random, pos);
        if (leaf.hasProperty((Property)CDLeavesBlock.GENERATED)) {
            leaf = (BlockState)leaf.setValue((Property)CDLeavesBlock.GENERATED, (Comparable)Boolean.valueOf(true));
        }
        setter.set(pos, leaf);
        if (random.nextInt(5) == 0 && level.isStateAtPosition(below = pos.below(), BlockBehaviour.BlockStateBase::isAir)) {
            setter.set(below, (BlockState)CDModBlocks.COCONUT.get().defaultBlockState().setValue((Property)CoconutBlock.HANGING, (Comparable)Boolean.valueOf(true)));
        }
    }
}

