/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.data.recipe;

import alabaster.crabbersdelight.common.registry.CDModItems;
import alabaster.crabbersdelight.common.tags.CDModTags;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import vectorwing.farmersdelight.common.crafting.FoodServingRecipe;
import vectorwing.farmersdelight.common.registry.ModItems;

public class CraftingRecipes {
    public static void register(RecipeOutput output) {
        CraftingRecipes.recipesTools(output);
        CraftingRecipes.recipesPalmWood(output);
        CraftingRecipes.recipesBlocks(output);
        CraftingRecipes.recipesMaterials(output);
        CraftingRecipes.recipesCraftedMeals(output);
        SpecialRecipeBuilder.special(FoodServingRecipe::new).save(output, "food_serving");
    }

    private static void recipesTools(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CDModItems.PEARL_NECKLACE.get()), (int)1).pattern(" P ").pattern("PSP").pattern(" P ").define(Character.valueOf('P'), (ItemLike)CDModItems.PEARL.get()).define(Character.valueOf('S'), (ItemLike)Items.STRING).unlockedBy("has_pearl", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PEARL.get()})).save(output);
    }

    private static void recipesPalmWood(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.PALM_WOOD.get()), (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)CDModItems.PALM_LOG.get()).unlockedBy("has_palm_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_LOG.get()})).group("bark").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.STRIPPED_PALM_WOOD.get()), (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)CDModItems.STRIPPED_PALM_LOG.get()).unlockedBy("has_stripped_palm_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.STRIPPED_PALM_LOG.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.PALM_PLANKS.get()), (int)4).requires(CDModTags.PALM_LOGS).unlockedBy("has_palm_logs", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_LOG.get()})).group("planks").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.PALM_STAIRS.get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.PALM_PLANKS.get()).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_stairs").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.PALM_SLAB.get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.PALM_PLANKS.get()).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_slab").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CDModItems.PALM_FENCE.get()), (int)3).pattern("W#W").pattern("W#W").define(Character.valueOf('W'), (ItemLike)CDModItems.PALM_PLANKS.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_fence").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)CDModItems.PALM_FENCE_GATE.get()), (int)1).pattern("#W#").pattern("#W#").define(Character.valueOf('W'), (ItemLike)CDModItems.PALM_PLANKS.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_fence_gate").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)CDModItems.PALM_DOOR.get()), (int)3).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)CDModItems.PALM_PLANKS.get()).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_door").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)CDModItems.PALM_TRAPDOOR.get()), (int)2).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.PALM_PLANKS.get()).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_trapdoor").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)CDModItems.PALM_PRESSURE_PLATE.get()), (int)1).pattern("##").define(Character.valueOf('#'), (ItemLike)CDModItems.PALM_PLANKS.get()).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_pressure_plate").save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)CDModItems.PALM_BUTTON.get()), (int)1).requires((ItemLike)CDModItems.PALM_PLANKS.get()).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_button").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CDModItems.PALM_SIGN.get()), (int)3).pattern("WWW").pattern("WWW").pattern(" # ").define(Character.valueOf('W'), (ItemLike)CDModItems.PALM_PLANKS.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("wooden_sign").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CDModItems.PALM_HANGING_SIGN.get()), (int)6).pattern("# #").pattern("WWW").pattern("WWW").define(Character.valueOf('W'), (ItemLike)CDModItems.STRIPPED_PALM_LOG.get()).define(Character.valueOf('#'), (ItemLike)Items.CHAIN).unlockedBy("has_stripped_palm_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.STRIPPED_PALM_LOG.get()})).group("hanging_sign").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CDModItems.PALM_BOAT.get()), (int)1).pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.PALM_PLANKS.get()).unlockedBy("has_palm_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_PLANKS.get()})).group("boat").save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CDModItems.PALM_CHEST_BOAT.get()), (int)1).requires((ItemLike)CDModItems.PALM_BOAT.get()).requires((ItemLike)Items.CHEST).unlockedBy("has_palm_boat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_BOAT.get()})).group("chest_boat").save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CDModItems.PALM_CABINET.get())).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), (ItemLike)CDModItems.PALM_SLAB.get()).define(Character.valueOf('D'), (ItemLike)CDModItems.PALM_TRAPDOOR.get()).unlockedBy("has_palm_trapdoor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PALM_TRAPDOOR.get()})).group("fd_cabinet").save(output);
    }

    private static void recipesBlocks(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.CRAB_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.RAW_CRAB.get()).unlockedBy("has_crab", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.RAW_CRAB.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.CLAM_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.CLAM.get()).unlockedBy("has_clam", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CLAM.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.CLAWSTER_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.RAW_CLAWSTER.get()).unlockedBy("has_clawster", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.RAW_CLAWSTER.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.SHRIMP_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.RAW_SHRIMP.get()).unlockedBy("has_shrimp", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.RAW_SHRIMP.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.COD_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.COD).unlockedBy("has_cod", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COD})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.SALMON_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.SALMON).unlockedBy("has_salmon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SALMON})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.PUFFERFISH_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.PUFFERFISH).unlockedBy("has_pufferfish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PUFFERFISH})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.TROPICAL_FISH_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.TROPICAL_FISH).unlockedBy("has_tropical_fish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.SQUID_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.RAW_SQUID_TENTACLES.get()).unlockedBy("has_raw_squid_tentacles", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.RAW_SQUID_TENTACLES.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.GLOW_SQUID_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.RAW_GLOW_SQUID_TENTACLES.get()).unlockedBy("has_raw_glow_squid_tentacles", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.RAW_GLOW_SQUID_TENTACLES.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.FROG_LEG_BARREL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.RAW_FROG_LEG.get()).unlockedBy("has_raw_frog_leg", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.RAW_FROG_LEG.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.COCONUT_CRATE.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.COCONUT.get()).unlockedBy("has_coconut", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.COCONUT.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.NAUTILUS_SHELL_BLOCK.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.NAUTILUS_SHELL).unlockedBy("has_nautilus_shell", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.NAUTILUS_SHELL})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.PEARL_BLOCK.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CDModItems.PEARL.get()).unlockedBy("has_pearl", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PEARL.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.SCUTE_BLOCK.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.TURTLE_SCUTE).unlockedBy("has_scute", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.TURTLE_SCUTE})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)CDModItems.SEA_PICKLE_CRATE.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.SEA_PICKLE).unlockedBy("has_sea_pickle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SEA_PICKLE})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CDModItems.CRAB_TRAP.get()), (int)1).pattern("nsn").pattern("s s").pattern("www").define(Character.valueOf('n'), (ItemLike)ModItems.SAFETY_NET.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('w'), ItemTags.WOODEN_SLABS).unlockedBy("has_stick", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STICK})).save(output);
    }

    private static void recipesMaterials(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.RAW_CRAB.get()), (int)9).requires((ItemLike)CDModItems.CRAB_BARREL.get()).unlockedBy("has_crab_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CRAB_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"crab_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.CLAM.get()), (int)9).requires((ItemLike)CDModItems.CLAM_BARREL.get()).unlockedBy("has_clam_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CLAM_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"clam_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.RAW_CLAWSTER.get()), (int)9).requires((ItemLike)CDModItems.CLAWSTER_BARREL.get()).unlockedBy("has_clawster_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CLAWSTER_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"clawster_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.RAW_SHRIMP.get()), (int)9).requires((ItemLike)CDModItems.SHRIMP_BARREL.get()).unlockedBy("has_shrimp_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.SHRIMP_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"shrimp_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.COD, (int)9).requires((ItemLike)CDModItems.COD_BARREL.get()).unlockedBy("has_cod_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.COD_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"cod_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.SALMON, (int)9).requires((ItemLike)CDModItems.SALMON_BARREL.get()).unlockedBy("has_salmon_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.SALMON_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"salmon_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.PUFFERFISH, (int)9).requires((ItemLike)CDModItems.PUFFERFISH_BARREL.get()).unlockedBy("has_pufferfish_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PUFFERFISH_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"pufferfish_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.TROPICAL_FISH, (int)9).requires((ItemLike)CDModItems.TROPICAL_FISH_BARREL.get()).unlockedBy("has_tropical_fish_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.TROPICAL_FISH_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"tropical_fish_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.RAW_SQUID_TENTACLES.get()), (int)9).requires((ItemLike)CDModItems.SQUID_BARREL.get()).unlockedBy("has_squid_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.SQUID_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"squid_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.RAW_GLOW_SQUID_TENTACLES.get()), (int)9).requires((ItemLike)CDModItems.GLOW_SQUID_BARREL.get()).unlockedBy("has_glow_squid_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.GLOW_SQUID_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"glow_squid_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.RAW_FROG_LEG.get()), (int)9).requires((ItemLike)CDModItems.FROG_LEG_BARREL.get()).unlockedBy("has_frog_leg_barrel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.FROG_LEG_BARREL.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"frog_leg_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.COCONUT.get()), (int)9).requires((ItemLike)CDModItems.COCONUT_CRATE.get()).unlockedBy("has_coconut_crate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.COCONUT_CRATE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"coconut_from_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.NAUTILUS_SHELL, (int)9).requires((ItemLike)CDModItems.NAUTILUS_SHELL_BLOCK.get()).unlockedBy("has_nautilus_shell_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.NAUTILUS_SHELL_BLOCK.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"nautilus_shell_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CDModItems.PEARL.get()), (int)9).requires((ItemLike)CDModItems.PEARL_BLOCK.get()).unlockedBy("has_pearl_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.PEARL_BLOCK.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"pearl_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TURTLE_SCUTE, (int)9).requires((ItemLike)CDModItems.SCUTE_BLOCK.get()).unlockedBy("has_scute_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.SCUTE_BLOCK.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"scute_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SEA_PICKLE, (int)9).requires((ItemLike)CDModItems.SEA_PICKLE_CRATE.get()).unlockedBy("has_sea_pickle_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.SEA_PICKLE_CRATE.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"sea_pickle_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BONE_MEAL, (int)3).requires((ItemLike)CDModItems.FISH_BONES.get()).unlockedBy("has_fish_bones", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.FISH_BONES.get()})).save(output, ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"bone_meal_from_fish_bones"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CDModItems.SEASHELLS.get()), (int)8).requires((ItemLike)CDModItems.CORAL_FRAGMENTS.get()).requires((ItemLike)CDModItems.CLAM.get()).requires((ItemLike)Items.NAUTILUS_SHELL).unlockedBy("has_clam", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CLAM.get()})).unlockedBy("has_coral_fragments", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).unlockedBy("has_nautilus_shell", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.NAUTILUS_SHELL})).save(output);
    }

    private static void recipesCraftedMeals(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.SHRIMP_SKEWER.get())).requires((ItemLike)Items.STICK).requires((ItemLike)CDModItems.COOKED_SHRIMP.get()).requires((ItemLike)CDModItems.COOKED_SHRIMP.get()).requires((ItemLike)ModItems.TOMATO.get()).unlockedBy("has_cooked_shrimp", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.COOKED_SHRIMP.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.FISH_STICK.get())).requires((ItemLike)Items.STICK).requires(Tags.Items.FOODS_COOKED_FISH).unlockedBy("has_cooked_fish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COOKED_COD, Items.COOKED_SALMON, (ItemLike)CDModItems.COOKED_TROPICAL_FISH.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.COCONUT_MILK.get())).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)CDModItems.COCONUT.get()).unlockedBy("has_cooked_fish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COOKED_COD, Items.COOKED_SALMON, (ItemLike)CDModItems.COOKED_TROPICAL_FISH.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.KELP_SHAKE.get())).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.KELP).requires((ItemLike)Items.KELP).requires((ItemLike)Items.KELP).requires((ItemLike)Items.KELP).unlockedBy("has_kelp", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.KELP})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.SURF_AND_TURF.get())).requires(CDModTags.COOKED_SEAFOOD).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.COOKED_BEEF).unlockedBy("has_baked_potato", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BAKED_POTATO})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.SQUID_KEBAB.get())).requires((ItemLike)Items.STICK).requires(CDModTags.COOKED_SQUID).requires((ItemLike)ModItems.ONION.get()).requires((ItemLike)ModItems.ONION.get()).requires((ItemLike)ModItems.TOMATO.get()).unlockedBy("has_cooked_squid", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.COOKED_SQUID_TENTACLES.get(), (ItemLike)CDModItems.COOKED_GLOW_SQUID_TENTACLES.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.FROG_LEG_KEBAB.get())).requires((ItemLike)Items.STICK).requires((ItemLike)CDModItems.COOKED_FROG_LEG.get()).requires((ItemLike)ModItems.ONION.get()).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)Items.CARROT).unlockedBy("has_cooked_frog_leg", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.COOKED_FROG_LEG.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.CORAL_CRUNCH.get()), (int)1).pattern(" m ").pattern("ccc").pattern(" b ").define(Character.valueOf('m'), (ItemLike)ModItems.MILK_BOTTLE.get()).define(Character.valueOf('b'), (ItemLike)Items.BOWL).define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)CDModItems.SEA_PICKLE_JUICE.get())).requires((ItemLike)Items.SEA_PICKLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_sea_pickle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SEA_PICKLE})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CDModItems.BUCKET_OF_CRAB_CHUM.get()), (int)1).pattern("mfm").pattern("fbf").pattern("mfm").define(Character.valueOf('f'), (ItemLike)Items.COD).define(Character.valueOf('b'), (ItemLike)Items.BUCKET).define(Character.valueOf('m'), (ItemLike)Items.BONE_MEAL).unlockedBy("has_bonemeal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CDModItems.BUCKET_OF_CLAWSTER_CHUM.get()), (int)1).pattern("mfm").pattern("fbf").pattern("mfm").define(Character.valueOf('f'), (ItemLike)Items.SALMON).define(Character.valueOf('b'), (ItemLike)Items.BUCKET).define(Character.valueOf('m'), (ItemLike)Items.BONE_MEAL).unlockedBy("has_bonemeal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CDModItems.BUCKET_OF_CLAM_CHUM.get()), (int)1).pattern("mfm").pattern("fbf").pattern("mfm").define(Character.valueOf('f'), (ItemLike)Items.PUFFERFISH).define(Character.valueOf('b'), (ItemLike)Items.BUCKET).define(Character.valueOf('m'), (ItemLike)Items.BONE_MEAL).unlockedBy("has_bonemeal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CDModItems.BUCKET_OF_SHRIMP_CHUM.get()), (int)1).pattern("mfm").pattern("fbf").pattern("mfm").define(Character.valueOf('f'), (ItemLike)Items.TROPICAL_FISH).define(Character.valueOf('b'), (ItemLike)Items.BUCKET).define(Character.valueOf('m'), (ItemLike)Items.BONE_MEAL).unlockedBy("has_bonemeal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.FIRE_CORAL_BLOCK, (int)1).pattern(" c ").pattern("cdc").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.RED_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.TUBE_CORAL_BLOCK, (int)1).pattern(" c ").pattern("cdc").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.BLUE_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.HORN_CORAL_BLOCK, (int)1).pattern(" c ").pattern("cdc").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.YELLOW_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BRAIN_CORAL_BLOCK, (int)1).pattern(" c ").pattern("cdc").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.PINK_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BUBBLE_CORAL_BLOCK, (int)1).pattern(" c ").pattern("cdc").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.MAGENTA_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FIRE_CORAL, (int)1).pattern("   ").pattern("cdc").pattern("   ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.RED_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TUBE_CORAL, (int)1).pattern("   ").pattern("cdc").pattern("   ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.BLUE_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HORN_CORAL, (int)1).pattern("   ").pattern("cdc").pattern("   ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.YELLOW_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BRAIN_CORAL, (int)1).pattern("   ").pattern("cdc").pattern("   ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.PINK_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BUBBLE_CORAL, (int)1).pattern("   ").pattern("cdc").pattern("   ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.MAGENTA_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FIRE_CORAL_FAN, (int)1).pattern(" c ").pattern(" d ").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.RED_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TUBE_CORAL_FAN, (int)1).pattern(" c ").pattern(" d ").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.BLUE_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HORN_CORAL_FAN, (int)1).pattern(" c ").pattern(" d ").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.YELLOW_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BRAIN_CORAL_FAN, (int)1).pattern(" c ").pattern(" d ").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.PINK_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BUBBLE_CORAL_FAN, (int)1).pattern(" c ").pattern(" d ").pattern(" c ").define(Character.valueOf('c'), (ItemLike)CDModItems.CORAL_FRAGMENTS.get()).define(Character.valueOf('d'), (ItemLike)Items.MAGENTA_DYE).unlockedBy("has_coral_fragment", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CDModItems.CORAL_FRAGMENTS.get()})).save(output);
    }
}

