/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.worlds.command.argument.SimpleArgumentType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CommandFlagsArgument
implements SimpleArgumentType<Flags, String> {
    private final Set<String> flags;

    public CommandFlagsArgument(Set<String> flags) {
        this.flags = flags;
    }

    @Override
    public Flags convert(StringReader reader, String type) {
        String[] split = type.split(" ");
        if (Arrays.stream(split).anyMatch(s -> !this.flags.contains(s))) {
            throw new IllegalArgumentException("unrecognized flag");
        }
        return new Flags(split);
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.greedyString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        int index = builder.getRemaining().lastIndexOf(32) + 1;
        String substring = builder.getRemaining().substring(index);
        this.flags.stream().filter(flag -> !builder.getRemaining().contains((CharSequence)flag)).filter(flag -> flag.startsWith(substring)).forEach(s -> builder.suggest(builder.getRemaining() + s.substring(substring.length())));
        return builder.buildFuture();
    }

    public static final class Flags
    extends HashSet<String> {
        private Flags(String ... flags) {
            super(Set.of(flags));
        }
    }
}

