/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.api.generator;

import net.thenextlvl.worlds.api.WorldsProvider;
import net.thenextlvl.worlds.api.exception.GeneratorException;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record Generator(Plugin plugin, @Nullable String id) {
    public String asString() {
        return this.id != null ? this.plugin.getName() + ":" + this.id : this.plugin.getName();
    }

    public @Nullable ChunkGenerator generator(String worldName) {
        return this.plugin().getDefaultWorldGenerator(worldName, this.id());
    }

    public @Nullable BiomeProvider biomeProvider(String worldName) {
        return this.plugin().getDefaultBiomeProvider(worldName, this.id());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Generator of(WorldsProvider provider, String string) throws GeneratorException {
        String[] split = string.split(":", 2);
        String plugin = split[0];
        String id = split.length > 1 ? split[1] : null;
        Plugin generator = provider.getServer().getPluginManager().getPlugin(plugin);
        if (generator == null) {
            throw new GeneratorException(plugin, id, "Unknown plugin");
        }
        if (!generator.isEnabled()) {
            throw new GeneratorException(plugin, id, "Plugin is not enabled, is it 'load: STARTUP'?");
        }
        if (!provider.generatorView().hasGenerator(generator)) {
            throw new GeneratorException(plugin, id, "Plugin has no generator");
        }
        return new Generator(generator, id);
    }
}

