/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.backup;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import net.thenextlvl.worlds.command.suggestion.BackupSuggestionProvider;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldBackupDeleteCommand
extends SimpleCommand {
    private WorldBackupDeleteCommand(WorldsPlugin plugin) {
        super(plugin, "delete", "worlds.command.backup.delete");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldBackupDeleteCommand command = new WorldBackupDeleteCommand(plugin);
        return command.create().then(WorldCommand.worldArgument(plugin).then(Commands.argument((String)"backup", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new BackupSuggestionProvider(plugin)).executes((Command)command)));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        World world = (World)context.getArgument("world", World.class);
        String backup = (String)context.getArgument("backup", String.class);
        Path resolved = this.plugin.levelView().getBackupFolder(world).resolve(backup + ".zip");
        boolean success = this.delete(world, resolved);
        String message = success ? "world.backup.delete.success" : "world.backup.delete.failed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName()), Placeholder.parsed((String)"identifier", (String)backup)});
        return success ? 1 : 0;
    }

    private boolean delete(World world, Path backup) {
        try {
            if (!Files.isRegularFile(backup, new LinkOption[0])) {
                return false;
            }
            Files.delete(backup);
            return true;
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to delete backup of world {} from {}", new Object[]{world.getName(), backup, e});
            return false;
        }
    }
}

