/*
 * Decompiled with CFR 0.152.
 */
package core.io;

import core.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PathIO
implements IO {
    private final Path path;

    PathIO(Path path) {
        this.path = path;
    }

    @Override
    public InputStream inputStream(OpenOption ... options) throws IOException {
        return Files.newInputStream(this.path, options);
    }

    @Override
    public OutputStream outputStream(OpenOption ... options) throws IOException {
        return Files.newOutputStream(this.path, options);
    }

    @Override
    public boolean createParents(FileAttribute<?> ... attributes) throws IOException {
        Path parent = this.path.toAbsolutePath().getParent();
        Files.createDirectories(parent, attributes);
        return true;
    }

    @Override
    public boolean exists(LinkOption ... options) {
        return Files.exists(this.path, options);
    }

    @Override
    public boolean delete() throws IOException {
        return Files.deleteIfExists(this.path);
    }

    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathIO)) {
            return false;
        }
        PathIO pathIO = (PathIO)o;
        return Objects.equals(this.path, pathIO.path);
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }
}

