/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.generator.DimensionType;
import net.thenextlvl.worlds.api.generator.GeneratorType;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class WorldInfoCommand
extends SimpleCommand {
    private WorldInfoCommand(WorldsPlugin plugin) {
        super(plugin, "info", "worlds.command.info");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldInfoCommand command = new WorldInfoCommand(plugin);
        return ((LiteralArgumentBuilder)command.create().then(WorldCommand.worldArgument(plugin).executes((Command)command))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        World world = this.tryGetArgument(context, "world", World.class).orElseGet(() -> ((CommandSourceStack)context.getSource()).getLocation().getWorld());
        Path path = world.getWorldFolder().toPath();
        Optional<Level> root = this.plugin.levelView().read(path).map(Level.Builder::build);
        this.plugin.bundle().sendMessage((Audience)sender, "world.info.name", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.key().asString()), Placeholder.parsed((String)"name", (String)world.getName())});
        this.plugin.bundle().sendMessage((Audience)sender, "world.info.players", Formatter.number((String)"players", (Number)world.getPlayers().size()));
        this.plugin.bundle().sendMessage((Audience)sender, "world.info.type", new TagResolver[]{Placeholder.parsed((String)"type", (String)root.map(Level::getGeneratorType).orElse(GeneratorType.NORMAL).name())});
        this.plugin.bundle().sendMessage((Audience)sender, "world.info.dimension", new TagResolver[]{Placeholder.parsed((String)"dimension", (String)root.map(level -> level.getLevelStem().dimensionType()).orElse(DimensionType.OVERWORLD).key().asString())});
        this.plugin.levelView().getGenerator(world).ifPresent(generator -> this.plugin.bundle().sendMessage((Audience)sender, "world.info.generator", new TagResolver[]{Placeholder.parsed((String)"generator", (String)generator.getName())}));
        this.plugin.bundle().sendMessage((Audience)sender, "world.info.seed", new TagResolver[]{Placeholder.parsed((String)"seed", (String)String.valueOf(world.getSeed()))});
        try {
            long bytes = this.getSize(path);
            double kb = (double)bytes / 1024.0;
            double mb = kb / 1024.0;
            double gb = mb / 1024.0;
            this.plugin.bundle().sendMessage((Audience)sender, "world.info.size", Formatter.number((String)"size", (Number)(gb >= 1.0 ? gb : (mb >= 1.0 ? mb : (kb >= 1.0 ? kb : (double)bytes)))), Formatter.choice((String)"unit", (Number)(gb >= 1.0 ? 0 : (mb >= 1.0 ? 1 : (kb >= 1.0 ? 2 : 3)))));
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to get world size for {}", (Object)world.key(), (Object)e);
        }
        return 1;
    }

    private long getSize(Path path) throws IOException {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return size.get();
    }
}

