/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.argument.WorldArgument;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import net.thenextlvl.worlds.command.suggestion.WorldSuggestionProvider;
import org.bukkit.Location;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldUnloadCommand
extends SimpleCommand {
    private WorldUnloadCommand(WorldsPlugin plugin) {
        super(plugin, "unload", "worlds.command.unload");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldUnloadCommand command = new WorldUnloadCommand(plugin);
        return command.create().then(((RequiredArgumentBuilder)WorldCommand.worldArgument(plugin).suggests(new WorldSuggestionProvider(plugin, (context, world) -> !plugin.levelView().isOverworld((World)world))).then(command.unloadFallback())).executes((Command)command));
    }

    private RequiredArgumentBuilder<CommandSourceStack, World> unloadFallback() {
        return (RequiredArgumentBuilder)Commands.argument((String)"fallback", (ArgumentType)new WorldArgument(this.plugin)).suggests(new WorldSuggestionProvider(this.plugin, (context, world) -> !world.equals(context.getLastChild().getArgument("world", World.class)))).executes((Command)this);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        World world = (World)context.getArgument("world", World.class);
        World fallback = this.tryGetArgument(context, "fallback", World.class).orElse(null);
        if (this.plugin.levelView().isOverworld(world)) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.unload.disallowed");
            return 0;
        }
        if (world.equals((Object)fallback)) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.unload.fallback");
            return 0;
        }
        Location fallbackSpawn = fallback != null ? fallback.getSpawnLocation() : this.plugin.levelView().getOverworld().getSpawnLocation();
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.unload", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())});
        ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])world.getPlayers().stream().map(player -> player.teleportAsync(fallbackSpawn)).toArray(CompletableFuture[]::new)).thenCompose(ignored -> {
            this.plugin.levelView().setEnabled(world, false);
            return this.plugin.levelView().unloadAsync(world, true);
        })).thenAccept(success -> {
            String message = success != false ? "world.unload.success" : "world.unload.failed";
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())});
        });
        return 1;
    }
}

