/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import net.thenextlvl.nbt.tag.EscapeTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class NBTOutputStream
extends DataOutputStream {
    private final Charset charset;

    public NBTOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, StandardCharsets.UTF_8);
    }

    public NBTOutputStream(OutputStream outputStream, Charset charset) throws IOException {
        super(new GZIPOutputStream(outputStream));
        this.charset = charset;
    }

    @Contract(mutates="this")
    public void writeTag(@Nullable String name, Tag tag) throws IOException, IllegalArgumentException {
        if (tag instanceof EscapeTag) {
            throw new IllegalArgumentException("EscapeTag not allowed");
        }
        byte[] bytes = name != null ? name.getBytes(this.getCharset()) : new byte[]{};
        this.writeByte(tag.getTypeId());
        this.writeShort(bytes.length);
        this.write(bytes);
        tag.write(this);
    }

    @Contract(pure=true)
    public Charset getCharset() {
        return this.charset;
    }
}

