/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.api.view;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.thenextlvl.worlds.api.level.Level;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.NonExtendable
public interface LevelView {
    @Contract(pure=true)
    public Path getBackupFolder();

    @Contract(pure=true)
    public Path getBackupFolder(World var1);

    @Contract(pure=true)
    public Path getWorldContainer();

    @Contract(pure=true)
    public String getEntryPermission(World var1);

    @Contract(value="_ -> new", pure=true)
    public Optional<Level.Builder> read(Path var1);

    @Contract(pure=true)
    public Optional<JavaPlugin> getGenerator(World var1);

    @Contract(pure=true)
    public @Unmodifiable Set<Path> listLevels();

    @Contract(pure=true)
    public boolean canLoad(Path var1);

    @Contract(pure=true)
    public boolean hasEndDimension(Path var1);

    @Contract(pure=true)
    public boolean hasNetherDimension(Path var1);

    @Contract(pure=true)
    public boolean isLevel(Path var1);

    @Deprecated(forRemoval=true, since="3.2.0")
    @Contract(mutates="io,param1")
    default public boolean unload(World world, boolean save) {
        return this.unloadAsync(world, save).join();
    }

    @Contract(mutates="io,param1")
    public CompletableFuture<Boolean> unloadAsync(World var1, boolean var2);

    @Deprecated(forRemoval=true, since="3.2.0")
    @Contract(mutates="io,param1")
    default public void save(World world, boolean flush) {
        this.saveAsync(world, flush).join();
    }

    @Contract(mutates="io,param1")
    public CompletableFuture<Void> saveAsync(World var1, boolean var2);

    @Deprecated(forRemoval=true, since="3.2.0")
    @Contract(mutates="io,param1")
    default public void saveLevelData(World world, boolean async) {
        CompletableFuture<Void> future = this.saveLevelDataAsync(world);
        if (!async) {
            future.join();
        }
    }

    @Contract(mutates="io,param1")
    public CompletableFuture<Void> saveLevelDataAsync(World var1);

    @Contract(pure=true)
    public boolean isEnabled(World var1);

    @Contract(mutates="param1")
    public void setEnabled(World var1, boolean var2);

    @Deprecated(forRemoval=true, since="3.3.1")
    @Contract(mutates="io,param1")
    default public long backup(World world) throws IOException {
        return this.backupAsync(world).join();
    }

    @Deprecated(forRemoval=true, since="3.7.0")
    @Contract(mutates="io,param1")
    default public CompletableFuture<Long> backupAsync(World world) {
        return this.createBackupAsync(world).thenApply(path -> {
            try {
                return Files.size(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to calculate backup size for " + String.valueOf(path), e);
            }
        });
    }

    @Contract(mutates="io,param1")
    default public CompletableFuture<Path> createBackupAsync(World world) {
        return this.createBackupAsync(world, null);
    }

    @Contract(mutates="io,param1")
    public CompletableFuture<Path> createBackupAsync(World var1, @Nullable String var2);

    @Contract(mutates="io,param1")
    public CompletableFuture<RestoringResult> restoreBackupAsync(World var1, Path var2, boolean var3);

    @Contract(mutates="this")
    public boolean cancelScheduledBackupRestoration(World var1);

    @Contract(pure=true)
    public boolean isBackupRestorationScheduled(World var1);

    @Contract(pure=true)
    public Stream<Path> listBackups(World var1);

    @Deprecated(forRemoval=true, since="3.2.0")
    @Contract(mutates="io,param1")
    default public Optional<World> clone(World world, Consumer<Level.Builder> builder, boolean full) throws IllegalArgumentException, IllegalStateException, IOException {
        return Optional.of(this.cloneAsync(world, builder, full).join());
    }

    @Contract(mutates="io,param1")
    public CompletableFuture<World> cloneAsync(World var1, Consumer<Level.Builder> var2, boolean var3);

    @Deprecated(forRemoval=true, since="3.2.0")
    @Contract(mutates="io,param1")
    default public DeletionResult delete(World world, boolean schedule) {
        return this.deleteAsync(world, schedule).join();
    }

    @Contract(mutates="io,param1")
    public CompletableFuture<DeletionResult> deleteAsync(World var1, boolean var2);

    @Contract(mutates="this")
    public boolean cancelScheduledDeletion(World var1);

    @Contract(pure=true)
    public boolean isDeletionScheduled(World var1);

    @Deprecated(forRemoval=true, since="3.2.0")
    @Contract(mutates="io,param1")
    default public DeletionResult regenerate(World world, boolean schedule) {
        return this.regenerateAsync(world, schedule).join();
    }

    @Contract(mutates="io,param1")
    public CompletableFuture<DeletionResult> regenerateAsync(World var1, boolean var2);

    @Contract(mutates="this")
    public boolean cancelScheduledRegeneration(World var1);

    @Contract(pure=true)
    public boolean isRegenerationScheduled(World var1);

    public static enum DeletionResult {
        SUCCESS,
        SCHEDULED,
        REQUIRES_SCHEDULING,
        UNLOAD_FAILED,
        FAILED;


        @Contract(pure=true)
        public boolean isSuccess() {
            return this == SUCCESS || this == SCHEDULED;
        }
    }

    public static interface RestoringResult {
        @Contract(pure=true)
        public @Nullable World world();

        @Contract(pure=true)
        public DeletionResult result();
    }
}

