/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.generator.Generator;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.command.argument.GeneratorArgument;
import net.thenextlvl.worlds.command.argument.KeyArgument;
import net.thenextlvl.worlds.command.argument.LevelPathArgument;
import net.thenextlvl.worlds.command.argument.LevelStemArgument;
import net.thenextlvl.worlds.command.brigadier.OptionCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldImportCommand
extends OptionCommand {
    private WorldImportCommand(WorldsPlugin plugin) {
        super(plugin, "import", "worlds.command.import");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldImportCommand command = new WorldImportCommand(plugin);
        return command.create().then(command.createCommand());
    }

    protected RequiredArgumentBuilder<CommandSourceStack, Path> createCommand() {
        RequiredArgumentBuilder command = (RequiredArgumentBuilder)Commands.argument((String)"path", (ArgumentType)new LevelPathArgument(this.plugin, true)).executes((Command)this);
        this.addOptions((ArgumentBuilder<CommandSourceStack, ?>)command, false, Set.of(new OptionCommand.Option("key", (ArgumentType<?>)new KeyArgument()), new OptionCommand.Option("generator", (ArgumentType<?>)new GeneratorArgument(this.plugin)), new OptionCommand.Option("name", (ArgumentType<?>)StringArgumentType.string()), new OptionCommand.Option("dimension", (ArgumentType<?>)new LevelStemArgument(this.plugin))), null);
        return command;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Path container;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Path path = (Path)context.getArgument("path", Path.class);
        if (!path.startsWith(container = this.plugin.levelView().getWorldContainer()) || path.getNameCount() != container.getNameCount() + 1) {
            this.plugin.bundle().sendMessage((Audience)sender, "world.container.load");
            return 0;
        }
        String displayName = this.tryGetArgument(context, "name", String.class).orElse(null);
        Generator generator = this.tryGetArgument(context, "generator", Generator.class).orElse(null);
        Key key = this.tryGetArgument(context, "key", Key.class).orElse(null);
        LevelStem dimension = this.tryGetArgument(context, "dimension", LevelStem.class).orElse(null);
        Optional<Level> build = this.plugin.levelView().read(path).map(level -> level.key(key).name(displayName).generator(generator).levelStem(dimension).build());
        CompletableFuture world = build.filter(level -> !level.isWorldKnown()).map(Level::createAsync).orElse(null);
        if (world == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "world.import.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)path.toString())});
            return 0;
        }
        this.plugin.bundle().sendMessage((Audience)sender, "world.import", new TagResolver[]{Placeholder.parsed((String)"world", (String)path.toString())});
        ((CompletableFuture)world.thenAccept(level -> {
            this.plugin.bundle().sendMessage((Audience)sender, "world.import.success", new TagResolver[]{Placeholder.parsed((String)"world", (String)level.getName())});
            if (!(sender instanceof Entity)) {
                return;
            }
            Entity entity = (Entity)sender;
            entity.teleportAsync(level.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        })).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)sender, "world.import.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)path.toString())});
            this.plugin.getComponentLogger().warn("Failed to import world {}", (Object)path, throwable);
            return null;
        });
        return 1;
    }
}

