/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.view.LevelView;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.argument.CommandFlagsArgument;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldRegenerateCommand
extends SimpleCommand {
    private WorldRegenerateCommand(WorldsPlugin plugin) {
        super(plugin, "regenerate", "worlds.command.regenerate");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldRegenerateCommand command = new WorldRegenerateCommand(plugin);
        return command.create().then(command.regenerate());
    }

    private RequiredArgumentBuilder<CommandSourceStack, World> regenerate() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)WorldCommand.worldArgument(this.plugin).then(Commands.argument((String)"flags", (ArgumentType)new CommandFlagsArgument(Set.of("--confirm", "--schedule"))).executes((Command)this))).executes(this::confirmationNeeded);
    }

    private int confirmationNeeded(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.plugin.bundle().sendMessage((Audience)sender, "command.confirmation", new TagResolver[]{Placeholder.parsed((String)"action", (String)("/" + context.getInput())), Placeholder.parsed((String)"confirmation", (String)("/" + context.getInput() + " --confirm"))});
        return 0;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandFlagsArgument.Flags flags = (CommandFlagsArgument.Flags)context.getArgument("flags", CommandFlagsArgument.Flags.class);
        if (!flags.contains("--confirm")) {
            return this.confirmationNeeded(context);
        }
        World world = (World)context.getArgument("world", World.class);
        boolean schedule = flags.contains("--schedule");
        if (!schedule) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.regenerate", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())});
        }
        ((CompletableFuture)this.plugin.levelView().regenerateAsync(world, schedule).thenAccept(result -> {
            String message = switch (result) {
                default -> throw new MatchException(null, null);
                case LevelView.DeletionResult.SUCCESS -> "world.regenerate.success";
                case LevelView.DeletionResult.SCHEDULED -> "world.regenerate.scheduled";
                case LevelView.DeletionResult.REQUIRES_SCHEDULING -> "world.regenerate.disallowed";
                case LevelView.DeletionResult.UNLOAD_FAILED -> "world.unload.failed";
                case LevelView.DeletionResult.FAILED -> "world.regenerate.failed";
            };
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())});
        })).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.regenerate.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())});
            this.plugin.getComponentLogger().warn("Failed to regenerate world {}", (Object)world.getName(), throwable);
            return null;
        });
        return 1;
    }
}

